/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_1;

import de.rtb.pcon.core.consts.AppConst;
import de.rtb.pcon.core.gdpr.GdprService;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.features.bonus.AppliedBonusKind;
import de.rtb.pcon.features.bonus.AppliedBonusRepository;
import de.rtb.pcon.features.bonus.basic.common.UiBonusProperties;
import de.rtb.pcon.features.bonus.basic.common.UiGivenBonus;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1ConfigEntity;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1Controller;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1ExceptionEntity;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1Service;
import de.rtb.pcon.features.bonus.basic_1.BonUiLcnStatistic;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingUtilsService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelUploadResult;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Tuple;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{id}/bonus/lpn/basic1"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonBasic1Controller {
    private static final Logger logger = LoggerFactory.getLogger(BonBasic1Controller.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private ExcelProcessingUtilsService excelProcessingUtilsService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private BonBasic1Service bonusService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private AppliedBonusRepository appliedBonusRepo;
    @Autowired
    private GdprService gdprService;

    BonBasic1Controller() {
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={ExcelProcessingException.class})
    public ResponseEntity<ExcelUploadResult> handleExcelImportException(ExcelProcessingException exWrapper) {
        return this.excelProcessingUtilsService.handleExcelImportException(exWrapper);
    }

    @GetMapping(value={"info"})
    @Transactional(readOnly=true)
    public BonUiLcnStatistic lncGetInfo(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        return this.bonusService.findConfigByZone(zone).map(bonus -> {
            BonUiLcnStatistic props = new BonUiLcnStatistic();
            OffsetDateTime startOfDay = ZonedDateTime.now(this.i18n.userTimeZoneId()).truncatedTo(ChronoUnit.DAYS).toOffsetDateTime();
            Tuple bonusStat = this.appliedBonusRepo.sumarizeUsedBonuses(AppliedBonusKind.BASIC_1, startOfDay, zone);
            props.setIssued(((Long)bonusStat.get("cnt", Long.class)).intValue());
            props.setTime(((Long)bonusStat.get("dur", Long.class)).intValue());
            props.setRules(this.bonusService.countExceptionInBonus(bonus));
            return props;
        }).orElseGet(BonUiLcnStatistic::new);
    }

    @GetMapping(value={"properties"})
    @Transactional(readOnly=true)
    public UiBonusProperties lncGetProperties(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        BonBasic1ConfigEntity bonus = this.bonusService.findConfigByZone(zone).orElseGet(() -> BonBasic1Service.createDefaultBonus((Zone)zone));
        return BonBasic1Controller.mkUiBonusPropertiesFrom((BonBasic1ConfigEntity)bonus);
    }

    @GetMapping(value={"usage/active"})
    @Transactional(readOnly=true)
    public Collection<UiGivenBonus> lncGetUsageActive(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        OffsetDateTime searchStart = OffsetDateTime.now().minus(AppConst.COMMON_SENSE_HISTORY_DEPTH);
        OffsetDateTime nowWithTolerance = DateTimeUtils.serverNowO().minusMinutes(10L);
        boolean isLpnProtected = this.gdprService.isLpnProtected();
        return this.appliedBonusRepo.findActiveByKindAndAreaAfter(AppliedBonusKind.BASIC_1, searchStart, nowWithTolerance, zone).stream().map(ab -> new UiGivenBonus(ab, userTimeZone, isLpnProtected)).toList();
    }

    @GetMapping(value={"usage/today"})
    @Transactional(readOnly=true)
    public Collection<UiGivenBonus> lncGetUsageToday(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        OffsetDateTime startOfDay = ZonedDateTime.now(userTimeZone).truncatedTo(ChronoUnit.DAYS).withZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime();
        boolean isLpnProtected = this.gdprService.isLpnProtected();
        return this.appliedBonusRepo.findAllByKindAndAreaAfter(AppliedBonusKind.BASIC_1, startOfDay, zone).stream().map(ab -> new UiGivenBonus(ab, userTimeZone, isLpnProtected)).toList();
    }

    @PostMapping(value={"properties"})
    @Transactional
    public UiBonusProperties lncSetProperties(@PathVariable(value="id") int zoneId, @RequestBody UiBonusProperties props) {
        String logDiff;
        Zone zone = this.entityLoader.loadZone(zoneId);
        BonBasic1ConfigEntity bonus = this.bonusService.findConfigByZone(zone).orElseGet(() -> this.bonusService.saveConfig(BonBasic1Service.createDefaultBonus((Zone)zone)));
        UiBonusProperties propsBase = BonBasic1Controller.mkUiBonusPropertiesFrom((BonBasic1ConfigEntity)bonus);
        bonus.setEnabled(props.enabled().booleanValue());
        bonus.setEmitCount(props.count().intValue());
        bonus.setRenewAt(props.resetPattern());
        bonus.setDuration(Duration.ofMinutes(props.time().intValue()));
        if (actionLogger.isInfoEnabled() && StringUtils.isNotEmpty((CharSequence)(logDiff = LoggerUtils.makeObjectDiff((Object)props, (Object)propsBase))) && actionLogger.isInfoEnabled()) {
            actionLogger.info(LoggerUtils.formatObjectDiff((User)this.securityService.getCurrentUser(), (String)("LPN bonus of " + LoggerUtils.log((Zone)zone)), (String)logDiff));
        }
        return BonBasic1Controller.mkUiBonusPropertiesFrom((BonBasic1ConfigEntity)bonus);
    }

    @PostMapping(value={"exceptions"})
    @Transactional
    public ResponseEntity<ExcelUploadResult> lncSetEcxeptions(@PathVariable(value="id") int zoneId, @RequestParam(value="rules") MultipartFile file) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        logger.info("Uploading data for 'LPN basic' bonus");
        Optional validationResult = this.excelProcessingUtilsService.validateEcxelUpload(file);
        if (validationResult.isPresent()) {
            return (ResponseEntity)validationResult.get();
        }
        BonBasic1ConfigEntity bonus = this.bonusService.findConfigByZone(zone).orElseGet(() -> this.bonusService.saveConfig(BonBasic1Service.createDefaultBonus((Zone)zone)));
        User currentUser = this.securityService.getCurrentUser();
        try {
            long nrOfDeletedEntries = this.bonusService.deleteExceptions(bonus);
            logger.debug("Deleted {} tariff exceptions.", (Object)nrOfDeletedEntries);
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info("The {} has deleted {} tariff bonus exceptions.", (Object)LoggerUtils.log((User)currentUser), (Object)nrOfDeletedEntries);
            }
            Workbook workbook = this.excelProcessingUtilsService.openWorkbookForStreaming(file);
            int numberOfInsertedExceptions = this.importLcnBonusExceptionsExcel(workbook, bonus);
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info("The {} has inserted {} tariff bonus exceptions.", (Object)LoggerUtils.log((User)currentUser), (Object)numberOfInsertedExceptions);
            }
            return new ResponseEntity((Object)new ExcelUploadResult(numberOfInsertedExceptions, this.i18n.getLocalizedMessage("document.import.sucess", new Object[0])), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new ExcelProcessingException((Throwable)e);
        }
    }

    private int importLcnBonusExceptionsExcel(Workbook workbook, BonBasic1ConfigEntity bonus) throws ExcelImportException {
        int rowNum = 0;
        int colNum = 0;
        int ruleCount = 0;
        try {
            Sheet sheet = workbook.getSheetAt(0);
            Iterator rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                rowNum = row.getRowNum();
                if (row.getLastCellNum() < 2) {
                    logger.warn("The row {} is skipped because it doesn't contain data.", (Object)(rowNum + 1));
                    continue;
                }
                BonBasic1ExceptionEntity bonException = new BonBasic1ExceptionEntity();
                bonException.setBonus(bonus);
                colNum = 0;
                Cell cell = row.getCell(colNum);
                String lpn = switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                    case 1 -> cell.getStringCellValue();
                    case 2 -> {
                        double num = cell.getNumericCellValue();
                        if (num == (double)((int)num)) {
                            yield Integer.toString((int)num);
                        }
                        throw new IllegalStateException("Invalid LPN: '" + num + "'");
                    }
                    default -> throw new IllegalStateException("Unsupported cell type " + String.valueOf(cell.getCellType()));
                };
                if (StringUtils.isEmpty((CharSequence)lpn)) {
                    throw new IllegalStateException("The cell is empty");
                }
                lpn = MessageParserHelper.parseLcn((String)lpn);
                bonException.setLpn(lpn);
                cell = row.getCell(++colNum);
                double durationInDays = cell.getNumericCellValue();
                Duration bonusTime = Duration.ofMinutes(Math.round(durationInDays * 24.0 * 60.0));
                bonException.setDuration(bonusTime);
                bonException = this.bonusService.saveException(bonException);
                this.entityManager.detach((Object)bonException);
                ++ruleCount;
            }
        }
        catch (Exception e) {
            throw new ExcelImportException(rowNum, colNum, (Throwable)e);
        }
        return ruleCount;
    }

    public static UiBonusProperties mkUiBonusPropertiesFrom(BonBasic1ConfigEntity bonus) {
        return new UiBonusProperties(Boolean.valueOf(bonus.isEnabled()), Integer.valueOf((int)bonus.getDuration().toMinutes()), Integer.valueOf(bonus.getEmitCount()), bonus.getRenewAt());
    }
}

