/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.core.integration.Crc16;
import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import de.rtb.pcon.core.services.pdm_in.ServerResponseBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ServerResponseBuilder.class);
    private static final MnemonicOrderComparator MNEMONIC_ORDER_COMPARATOR = new MnemonicOrderComparator();
    private static final int DEFAULT_CAPACITY = 100;
    private final Map<String, Object> properties;
    private Charset charset;
    private BuilderMode mode = BuilderMode.EMPTY;
    private ByteArrayOutputStream binaryData;
    private Map<String, String> mnemonics;
    private boolean processingError;

    public ServerResponseBuilder(Charset charset) {
        this.charset = charset;
        this.binaryData = new ByteArrayOutputStream(100);
        this.properties = new HashMap();
        this.processingError = false;
        this.mnemonics = new HashMap();
    }

    public ServerResponseBuilder(Charset charset, int capacity) {
        this.charset = charset;
        this.binaryData = new ByteArrayOutputStream(capacity);
        this.properties = new HashMap();
        this.processingError = false;
        this.mnemonics = new HashMap();
    }

    public Charset charset() {
        return this.charset;
    }

    public ServerResponseBuilder append(String name, String value) {
        if (this.mode == BuilderMode.BINARY) {
            throw new IllegalStateException("Response builder is in binary mode");
        }
        this.mode = BuilderMode.ASCII;
        if (this.mnemonics.containsKey(name)) {
            String oldValue = (String)this.mnemonics.get(name);
            if (oldValue.equals(value)) {
                log.info("Mnemonic {} replaced. No change in value.", (Object)name);
            } else {
                log.warn("Mnemonic {} replaced. Value changed from {} to {}.", new Object[]{name, oldValue, value});
            }
        }
        this.mnemonics.put(name, value);
        return this;
    }

    public ServerResponseBuilder append(String name) {
        return this.append(name, "");
    }

    public ServerResponseBuilder append(String name, int value) {
        return this.append(name, Integer.toString(value));
    }

    public ServerResponseBuilder append(String name, long value) {
        return this.append(name, Long.toString(value));
    }

    public ServerResponseBuilder append(Map<String, String> mnemonics) {
        this.mnemonics.putAll(mnemonics);
        return this;
    }

    public boolean containsMnemonic(String name) {
        return this.mnemonics.containsKey(name);
    }

    public ServerResponseBuilder append(byte[] b) {
        if (this.mode == BuilderMode.ASCII) {
            throw new IllegalStateException("Response builder is in ASCII mode");
        }
        this.mode = BuilderMode.BINARY;
        try {
            this.binaryData.write(b);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public BuilderMode getMode() {
        return this.mode;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProcessingError() {
        this.processingError = true;
    }

    public boolean isProcessingError() {
        return this.processingError;
    }

    public String toString() {
        ArrayList mKeys = new ArrayList();
        mKeys.addAll(this.mnemonics.keySet());
        Collections.sort(mKeys, MNEMONIC_ORDER_COMPARATOR);
        StringBuilder result = new StringBuilder();
        for (String key : mKeys) {
            result.append(key);
            result.append((String)this.mnemonics.get(key));
            result.append(";");
        }
        return result.toString();
    }

    public ServerResponse build() {
        ServerResponse serverResponse;
        if (this.mode == BuilderMode.BINARY) {
            String description = String.format("Binary data %d bytes long.", this.binaryData.toByteArray().length);
            return new ServerResponse(this.binaryData.toByteArray(), this.properties, description);
        }
        Object messageString = this.toString();
        byte[] messageBytes = ((String)messageString).getBytes(this.charset);
        ByteArrayOutputStream out = new ByteArrayOutputStream(messageBytes.length + 7);
        try {
            String crc = Crc16.calculateCrcString((byte[])messageBytes);
            out.write(messageBytes);
            out.write("CRC".getBytes(this.charset));
            out.write(crc.getBytes(this.charset));
            messageString = (String)messageString + "CRC" + crc;
            serverResponse = new ServerResponse(out.toByteArray(), this.charset, this.properties, (String)messageString);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return serverResponse;
    }
}

