/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class ServerResponse {
    private ContentType contentType;
    private Charset charset;
    private byte[] data;
    private Map<String, Object> properties;
    private String description;

    public ServerResponse(byte[] data, Map<String, Object> properties, String description) {
        this.data = data;
        this.contentType = ContentType.BINARY;
        this.charset = null;
        this.properties = properties;
        this.description = description;
    }

    public ServerResponse(byte[] data, Charset charset, Map<String, Object> properties, String description) {
        this.data = data;
        this.charset = charset;
        this.contentType = ContentType.TEXT;
        this.properties = properties;
        this.description = description;
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public Map<String, Object> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        if (this.charset != null && this.data != null) {
            return new String(this.data, this.charset);
        }
        if (this.data != null) {
            return String.format("Binary data %d bytes long.", this.data.length);
        }
        return "Null data.";
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public String description() {
        return this.description;
    }
}

