/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.remote_actions;

import de.rtb.pcon.core.remote_actions.RemoteActionSevice;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.RemoteAction;
import de.rtb.pcon.model.RemoteActionState;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.repositories.RemoteActionRepository;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.annotation.PostConstruct;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RemoteActionSevice {
    private static final Logger logger = LoggerFactory.getLogger(RemoteActionSevice.class);
    private Set<Integer> reqCache = new HashSet();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    @Autowired
    private RemoteActionRepository repo;
    private static final Set<RemoteActionState> RAS_WAING = Set.of(RemoteActionState.SHEDULED, RemoteActionState.IN_PROGRESS);

    @Transactional
    public RemoteAction add(Pdm pdm, User user, int actionCode, String parameters) {
        RemoteAction ra = new RemoteAction();
        ra.setCode(actionCode);
        ra.setParmeters(parameters);
        ra.setState(RemoteActionState.SHEDULED);
        ra.setSubmitDate(OffsetDateTime.now());
        ra.setPdm(pdm);
        ra.setRequester(user);
        this.repo.save((Object)ra);
        this.reLoadReqCache();
        return ra;
    }

    @Transactional
    public void remove(RemoteAction ra) {
        this.repo.delete((Object)ra);
        this.reLoadReqCache();
    }

    @Transactional
    public int executionQueueLength(Pdm pdm) {
        return this.repo.findByPdmAndStateInOrderByIdAsc(pdm, (Collection)RAS_WAING).size();
    }

    @Transactional
    public List<RemoteAction> list(Pdm pdm) {
        return this.repo.findByPdmOrderById(pdm);
    }

    public boolean check(Pdm pdm) {
        boolean contains;
        this.lock.readLock().lock();
        try {
            contains = this.reqCache.contains(pdm.getId());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return contains;
    }

    @Transactional
    public NextRemoteAction next(Pdm pdm) {
        List actions = this.repo.findByPdmAndStateInOrderByIdAsc(pdm, (Collection)RAS_WAING);
        if (actions.isEmpty()) {
            return null;
        }
        RemoteAction act = (RemoteAction)actions.get(0);
        act.setState(RemoteActionState.IN_PROGRESS);
        return new NextRemoteAction(act.getCode(), act.getParmeters(), act.getSubmitDate());
    }

    @Transactional
    public void resolve(Pdm pdm, int actionCode, StatusMessage statusMessage) {
        Optional<RemoteAction> rao = this.repo.findByPdmAndStateInOrderByIdAsc(pdm, (Collection)RAS_WAING).stream().filter(a -> actionCode == a.getCode()).findFirst();
        if (logger.isInfoEnabled() && rao.isEmpty()) {
            logger.info("Remote action {} performed by {} was not requested.", (Object)actionCode, (Object)LoggerUtils.log((Pdm)pdm));
            return;
        }
        RemoteAction ra = rao.get();
        ra.setResult(statusMessage);
        ra.setState(RemoteActionState.DONE);
        this.reLoadReqCache();
    }

    @PostConstruct
    private void reLoadReqCache() {
        this.lock.writeLock().lock();
        try {
            this.reqCache.clear();
            this.reqCache.addAll(this.repo.listPdmIdsWithActionState((Collection)RAS_WAING));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

