/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.core.notification.NotificationMessageMail;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
class MailSenderService {
    private static final Logger log = LoggerFactory.getLogger(MailSenderService.class);
    private static final Predicate<String> rtbAddress = a -> StringUtils.endsWith((CharSequence)a, (CharSequence)"@rtb-bl.de");
    @Autowired
    private DevelopmentProperties devProps;
    @Autowired
    private JavaMailSender emailSender;

    MailSenderService() {
    }

    public void sendMessage(NotificationMessageMail msg) {
        block4: {
            long sendStart = System.currentTimeMillis();
            MimeMessage mm = msg.getMimeMessage();
            try {
                if (this.devProps.isFilterEmails()) {
                    this.filterRecipients(mm, Message.RecipientType.TO);
                    this.filterRecipients(mm, Message.RecipientType.CC);
                    this.filterRecipients(mm, Message.RecipientType.BCC);
                }
                this.emailSender.send(msg.getMimeMessage());
                if (log.isDebugEnabled()) {
                    String recipientsStr = Arrays.stream(msg.getMimeMessage().getAllRecipients()).map(Address::toString).collect(Collectors.joining(","));
                    String subject = msg.getMimeMessage().getSubject();
                    long duration = System.currentTimeMillis() - sendStart;
                    log.debug("Message was sent to {} (Subject: {}), {} ms).", new Object[]{recipientsStr, subject, duration});
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                long procDuration = System.currentTimeMillis() - sendStart;
                String emsg = "E-mail sub-system failed to process the request (took " + procDuration + " ms).";
                log.error(emsg, (Throwable)e);
            }
        }
    }

    void filterRecipients(MimeMessage msg, Message.RecipientType type) {
        try {
            String headerContent = msg.getHeader(type.toString(), ",");
            if (StringUtils.isEmpty((CharSequence)headerContent)) {
                return;
            }
            List<String> headerValue = Arrays.stream(StringUtils.split((String)headerContent, (String)",")).map(String::trim).toList();
            List accepted = headerValue.stream().filter(rtbAddress).toList();
            if (headerValue.size() > accepted.size()) {
                msg.setRecipients(type, accepted.stream().collect(Collectors.joining(",")));
                if (log.isWarnEnabled()) {
                    List<String> removed = headerValue.stream().filter(a -> !accepted.contains(a)).toList();
                    log.warn("Unsafe addresses were remove from '{}' header ({}).", (Object)type, removed);
                }
            }
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException("Cannot update recipients of type " + String.valueOf(type) + ".", e);
        }
    }
}

