/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_presistence;

import de.rtb.pcon.core.events.PaymentReceivedEvent;
import de.rtb.pcon.core.integration.PdmMessageDuplicated;
import de.rtb.pcon.core.msg_presistence.PaymentTransactionPersitenceService;
import de.rtb.pcon.core.msg_presistence.PaymentTransactionService;
import de.rtb.pcon.core.msg_presistence.PaymentTransactionUtils;
import de.rtb.pcon.core.msg_presistence.payment.cpf.CustomPaymentFieldService;
import de.rtb.pcon.core.real_time_parking.RealTimeParkingService;
import de.rtb.pcon.core.runtime_monitor.TariffService;
import de.rtb.pcon.core.services.pdm_in.ExtensiblePermitDbId;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PaymentTransactionService {
    private static final Logger log = LoggerFactory.getLogger(PaymentTransactionService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PdmRepository pdmRepository;
    @Autowired
    private PaymentTransactionRepository paymentTransactionRepository;
    @Autowired
    private CustomPaymentFieldService cpfService;
    @Autowired
    private RealTimeParkingService rtpService;
    @Autowired
    private PaymentTransactionRepository paymentTrasactionRepo;
    @Autowired
    private PaymentTransactionPersitenceService paymentTransactionPersitenceService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Transactional(noRollbackFor={PdmMessageDuplicated.class})
    public PaymentTransaction process(PdmMessageDto msg) {
        PaymentTransaction paymentPdm = PaymentTransactionService.mapPdmTransactionMessage((PdmMessageDto)msg);
        PaymentTransaction payment = this.savePayment(paymentPdm);
        if (StringUtils.isNotBlank((CharSequence)msg.getPti())) {
            this.rtpService.registerRtp(payment, msg.getPti());
        }
        return payment;
    }

    PaymentTransaction savePayment(PaymentTransaction pt) {
        int attemptNr;
        int maxAttempts = 3;
        OffsetDateTime originalPdmTs = pt.getId().getPdmTime();
        for (attemptNr = 1; attemptNr < maxAttempts; ++attemptNr) {
            try {
                this.paymentTransactionPersitenceService.insertToDb(pt);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new PaymentReceivedEvent((Object)this, pt));
                if (attemptNr > 1) {
                    log.info("Payment time adjusted from {} to {} after {} attempts.", new Object[]{pt.getId().getPdmTime(), originalPdmTs, attemptNr});
                }
                return pt;
            }
            catch (PdmMessageDuplicated e) {
                log.debug("It was not possible to save Payment (attempt {}). Primary key already exists.", (Object)attemptNr);
                boolean adjusted = this.adjustPayment(pt);
                if (adjusted) {
                    continue;
                }
                throw new PdmMessageDuplicated("Payment is already stored in the database. Ignoring.");
            }
        }
        log.warn("It was not possible to save Payment (attempt {}). Primary key already exists.", (Object)attemptNr);
        throw new PdmMessageDuplicated(MessageFormat.format("It was not possible to insert the message to the database. It is still resolved as duplicated after {0} tries.", attemptNr));
    }

    boolean adjustPayment(PaymentTransaction pt) {
        OffsetDateTime startOfMinute = pt.getId().getPdmTime().truncatedTo(ChronoUnit.MINUTES);
        OffsetDateTime nextMinute = startOfMinute.plusMinutes(1L);
        List existingPayments = this.paymentTransactionRepository.findforPdmAndTimeBetween(pt.getId().getPdm(), startOfMinute, nextMinute);
        if (PaymentTransactionUtils.isDuplicate((PaymentTransaction)pt, (List)existingPayments)) {
            log.atWarn().setMessage("Payment message {}, {}, TRC {} is already stored. It will be ignored.").addArgument(() -> LoggerUtils.logPdmAndArea((Pdm)pt.getId().getPdm())).addArgument(() -> pt.getId().getPdmTime()).addArgument(() -> ((PaymentTransaction)pt).getTracerNumber()).log();
            return false;
        }
        List<Integer> usedSeconds = existingPayments.stream().map(p -> p.getId().getPdmTime().getSecond()).toList();
        int currentSecond = pt.getId().getPdmTime().getSecond();
        int freeSecond = PaymentTransactionUtils.findAvailableSecond((Integer)currentSecond, usedSeconds);
        OffsetDateTime newPaymentTime = pt.getId().getPdmTime().withSecond(freeSecond);
        OffsetDateTime origPaymentTime = pt.getId().getPdmTime();
        log.atDebug().setMessage("Payment time adjusted {} -> {} ({} seconds)").addArgument((Object)origPaymentTime).addArgument((Object)newPaymentTime).addArgument(() -> Duration.between(origPaymentTime, newPaymentTime).toSeconds()).log();
        pt.getId().setPdmTime(newPaymentTime);
        return true;
    }

    @Transactional
    public void processCustomPaymentField(PdmMessageDto m) {
        if (StringUtils.isBlank((CharSequence)m.getCpf())) {
            return;
        }
        this.cpfService.modifyCpf(m.getPdm(), m.getCpf());
    }

    @Transactional
    public PaymentTransaction persistParkingTicketExtension(PdmMessageDto m) {
        ExtensiblePermitDbId eid = (ExtensiblePermitDbId)m.getEid().orElseThrow();
        PaymentTransactionId originalPaymentId = new PaymentTransactionId((Pdm)this.pdmRepository.getReferenceById((Object)eid.pdmId()), eid.payTs().atOffset(ZoneOffset.UTC));
        PaymentTransaction originalPayment = this.paymentTrasactionRepo.findById((Object)originalPaymentId).orElse(null);
        TariffInfo tariffInfo = null;
        OffsetDateTime originalParkingEnd = null;
        if (originalPayment != null) {
            originalParkingEnd = originalPayment.getParkEndTime();
            originalPayment.setParkEndTime(m.getParkEnd());
            tariffInfo = originalPayment.getTariffInfo();
            if (originalPayment.getBasePermit() == null) {
                originalPayment.setBasePermit(originalPayment);
            }
        } else {
            log.error("Required payment #{} to extend was not found.", (Object)m.getEid());
        }
        if (tariffInfo == null) {
            tariffInfo = TariffService.findTariffInfo((Pdm)m.getPdm(), (Integer)m.getTid());
        }
        PaymentTransaction extendingPayment = PaymentTransactionService.mapPdmTransactionMessage((PdmMessageDto)m);
        if (originalParkingEnd != null) {
            extendingPayment.getId().setPdmTime(originalParkingEnd);
        } else {
            log.warn("Base permit to extend was not found. Start time of this parking permit is not aligned with parking end of base permit.");
        }
        extendingPayment.setTariffInfo(tariffInfo);
        BigDecimal parkingAmount = m.getBep() == null ? m.getBet() : m.getBet().subtract(m.getBep());
        extendingPayment.setAmount(parkingAmount);
        extendingPayment.setPaymentReason(PaymentReason.PERMIT_EXTENSION);
        extendingPayment.setBasePermit(originalPayment);
        this.savePayment(extendingPayment);
        if (m.getBep() != null) {
            PaymentTransaction penaltyPayment = PaymentTransactionService.mapPdmPaymentPenalty((PdmMessageDto)m);
            this.savePayment(penaltyPayment);
        }
        return extendingPayment;
    }

    static final PaymentTransaction mapPdmTransactionMessage(PdmMessageDto msg) {
        PaymentTransaction pay = new PaymentTransaction();
        pay.setId(new PaymentTransactionId(msg.getPdm(), msg.getDatTim()));
        pay.setTracerNumber(msg.getTrc().intValue());
        pay.setServerTime(DateTimeUtils.serverNowO());
        pay.setPaymentReason(msg.getStp());
        pay.setPaymentType(msg.getBza());
        if (msg.getUst() != null) {
            switch (1.$SwitchMap$de$rtb$pcon$model$PaymentUserType[msg.getUst().ordinal()]) {
                case 1: {
                    pay.setPaymentReason(PaymentReason.ZERO_TICKET);
                    break;
                }
                case 2: {
                    pay.setPaymentReason(PaymentReason.JETON);
                    break;
                }
            }
        }
        pay.setAmount(msg.getBet());
        if (msg.getParkEnd() != null) {
            pay.setParkEndTime(msg.getParkEnd());
        } else {
            pay.setParkEndTime(null);
        }
        pay.setTicketNumber(msg.getTin().intValue());
        if (msg.getStp() == PaymentReason.RECONCILIATION) {
            pay.setPaymentCode(null);
        } else {
            pay.setPaymentCode(msg.getZid());
        }
        pay.setCurrency(msg.getWkz());
        pay.setCardType(msg.getTyp());
        pay.setLpn(msg.getLcn());
        pay.setSpecialCode(msg.getSke());
        pay.setPsn(msg.getPan());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isEmpty((CharSequence)msg.getTrf())) {
            pay.setAuthCode(msg.getAth());
        } else if (StringUtils.isEmpty((CharSequence)msg.getAth()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            pay.setAuthCode(msg.getTrf());
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            throw new IllegalStateException("Only one of ATH or TRF codes can be present.");
        }
        pay.setTariffInfo(TariffService.findTariffInfo((Pdm)msg.getPdm(), (Integer)msg.getTid()));
        return pay;
    }

    static final PaymentTransaction mapPdmPaymentPenalty(PdmMessageDto msg) {
        PaymentTransaction pay = new PaymentTransaction();
        pay.setId(new PaymentTransactionId(msg.getPdm(), msg.getDatTim()));
        pay.setTracerNumber(msg.getTrc().intValue());
        pay.setServerTime(DateTimeUtils.serverNowO());
        pay.setPaymentReason(PaymentReason.PENALTY);
        pay.setPaymentType(msg.getBza());
        pay.setAmount(msg.getBep());
        pay.setTicketNumber(msg.getTin().intValue());
        pay.setCurrency(msg.getWkz());
        if (msg.getStp() == PaymentReason.RECONCILIATION) {
            pay.setPaymentCode(null);
        } else {
            pay.setPaymentCode(msg.getZid());
        }
        pay.setLpn(msg.getLcn());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isEmpty((CharSequence)msg.getTrf())) {
            pay.setAuthCode(msg.getAth());
        } else if (StringUtils.isEmpty((CharSequence)msg.getAth()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            pay.setAuthCode(msg.getTrf());
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getAth()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{msg.getTrf()})) {
            throw new IllegalStateException("Only one of ATH or TRF codes can be present.");
        }
        return pay;
    }
}

