/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_fw;

import de.rtb.pcon.core.msg_fw.MessageForwardingDataProviderService;
import de.rtb.pcon.core.notification.NotificationService;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import de.rtb.pcontrol.utils.NumberUtils2;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageForwardingService {
    @Autowired
    private MessageForwardingDataProviderService mfwDataServce;
    @Autowired
    private NotificationService notificationService;

    public void fowardIfNeeded(StatusMessage m) {
        List rules = this.mfwDataServce.gerAreaRules(m.getPdm().getZone().getArea());
        Predicate<MessageForwardingRule> predIsActive = MessageForwardingRule::isActive;
        Predicate<MessageForwardingRule> predPdmNumber = r -> MessageForwardingService.collectionFilterAllows((Collection)r.getPdmNumbers(), (Object)m.getPdm().getNumber());
        Predicate<MessageForwardingRule> predAlertType = r -> MessageForwardingService.collectionFilterAllows((Collection)r.getAlertTypes(), (Object)m.getMessageConfig().getAlertType());
        Predicate<MessageForwardingRule> predMsgNumber = r -> MessageForwardingService.collectionFilterAllows((Collection)r.getMessageNumbers(), (Object)NumberUtils2.shortToInteger((Short)m.getMessageConfig().getNumber()));
        Predicate<MessageForwardingRule> predTime = r -> {
            ZonedDateTime now = ZonedDateTime.now(ZoneId.of(r.getUser().getTimeZoneName()));
            DayOfWeek dayOfWeek = now.getDayOfWeek();
            return MessageForwardingService.collectionFilterAllows((Collection)r.getDaysOfWeek(), (Object)dayOfWeek) && MessageForwardingService.timeInRagne((LocalTime)r.getTimeBegin(), (LocalTime)r.getTimeEnd(), (LocalTime)now.toLocalTime());
        };
        rules.stream().filter(predIsActive.and(predTime).and(predMsgNumber).and(predAlertType).and(predPdmNumber)).forEach(r -> this.notificationService.sendStatusForwarding(r, m));
    }

    static boolean timeInRagne(LocalTime start, LocalTime end, LocalTime now) {
        start = Optional.ofNullable(start).orElse(LocalTime.MIN);
        end = Optional.ofNullable(end).orElse(LocalTime.MAX);
        end = end.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L).minusNanos(1L);
        boolean dayRule = start.isBefore(end);
        boolean result = false;
        result = dayRule ? now.isAfter(start) && now.isBefore(end) : now.isBefore(end) || now.isAfter(start);
        return result;
    }

    static <T> boolean collectionFilterAllows(Collection<T> collection, T element) {
        return CollectionUtils.isEmpty(collection) || collection.contains(element);
    }
}

