/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Crc16 {
    public static final int DEFAULT_CRC_INIT_VALUE = 65535;
    private int crc;

    public Crc16() {
        this.crc = 65535;
    }

    public Crc16(int initValue) {
        this.crc = initValue;
    }

    public void reset() {
        this.crc = 65535;
    }

    public void addBytes(byte[] data) {
        this.crc = Crc16.calculateCrc((byte[])data, (int)this.crc);
    }

    public int getCrc() {
        return this.crc;
    }

    public static final int stringCrcToNumer(String crcString) {
        return Integer.parseInt(crcString, 16);
    }

    public static final String numberCrcToString(int crc) {
        String crcString = Integer.toHexString(crc);
        String crcPadded = StringUtils.leftPad((String)crcString, (int)4, (char)'0');
        String crcUpper = StringUtils.upperCase((String)crcPadded);
        return crcUpper;
    }

    public static final String calculateCrcString(byte[] data) {
        return Crc16.calculateCrcString((byte[])data, (int)65535);
    }

    public static final String calculateCrcString(byte[] data, int initCrc) {
        int crc = Crc16.calculateCrc((byte[])data, (int)initCrc);
        return Crc16.numberCrcToString((int)crc);
    }

    public static final int calculateCrc(byte[] data, int initCrc) {
        int workCrc = initCrc;
        int crcConst = 255;
        int secondCrcConst = 65535;
        for (byte t : data) {
            int tempVal = ((workCrc ^= t & crcConst) ^ workCrc << 4) & crcConst;
            workCrc = workCrc >> 8 ^ tempVal << 8 ^ tempVal << 3 ^ tempVal >> 4;
            workCrc &= secondCrcConst;
        }
        return workCrc;
    }
}

