/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.plan;

import de.rtb.pcon.core.fw_download.ui.plan.SoftwareVersionAndDownloadTarget;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;

class UiPlanDefinition {
    private Integer id;
    private String name;
    private int area;
    private List<Integer> pdms;
    private String note;
    private LocalDate downloadDate;
    private LocalTime downloadTime;
    private LocalDate activationDate;
    private SoftwareVersionAndDownloadTarget sw;

    public UiPlanDefinition() {
    }

    public UiPlanDefinition(DownloadPlan plan, ZoneId timeZone) {
        this.id = plan.getId();
        this.name = plan.getName();
        this.area = plan.getArea().getId();
        this.pdms = plan.getEntries().stream().map(entry -> entry.getPdm().getId()).collect(Collectors.toList());
        this.note = plan.getNote();
        LocalDateTime downloadDt = DateTimeUtils.toLocalDateTime((OffsetDateTime)plan.getDownloadTime(), (ZoneId)timeZone);
        this.downloadDate = downloadDt.toLocalDate();
        this.downloadTime = downloadDt.toLocalTime();
        this.activationDate = plan.getActivationDate();
        this.sw = new SoftwareVersionAndDownloadTarget(plan);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getArea() {
        return this.area;
    }

    public void setArea(int area) {
        this.area = area;
    }

    public List<Integer> getPdms() {
        return this.pdms;
    }

    public void setPdms(List<Integer> pdms) {
        this.pdms = pdms;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public LocalDate getDownloadDate() {
        return this.downloadDate;
    }

    public void setDownloadDate(LocalDate downloadDate) {
        this.downloadDate = downloadDate;
    }

    public LocalDate getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(LocalDate activationDate) {
        this.activationDate = activationDate;
    }

    public LocalTime getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadTime(LocalTime downloadTime) {
        this.downloadTime = downloadTime;
    }

    public SoftwareVersionAndDownloadTarget getSw() {
        return this.sw;
    }

    public void setSw(SoftwareVersionAndDownloadTarget sw) {
        this.sw = sw;
    }
}

