/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceIp;
import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceUdp;
import de.rtb.pcon.core.fw_download.WanProps;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.core.services.pdm_in.ServerResponseBuilder;
import de.rtb.pcon.core.services.pdm_in.SoftwareDataProvider;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.model.download.SoftwareItem;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pdmFirmwareDownloadUdp")
public class FirmwareDownloadServiceUdp
extends FirmwareDownloadServiceIp {
    private static final Logger logger = LoggerFactory.getLogger(FirmwareDownloadServiceUdp.class);
    @Autowired
    private SoftwareDataProvider swDataProvider;
    private static final int BLOCK_LENGTH_IN_BYTES = 256;
    private static final int TRANSMITION_SIZE_IN_BLOCKS = 50;

    public FirmwareDownloadServiceUdp(WanProps config) {
        super(config.getIp(), config.getUdpPort());
    }

    @Transactional(readOnly=true)
    public void getMetaData(PdmMessageDto m, ServerResponseBuilder response) {
        Optional downloadEntryO = this.getFirmwareDescription(m.getPdm(), this.getTarget(m));
        if (downloadEntryO.isPresent()) {
            SoftwareItem swi;
            DownloadEntry downloadEntry = (DownloadEntry)downloadEntryO.get();
            if (m.getApp() == null || m.getApp().equals("CPU7")) {
                swi = this.swDataProvider.getSoftwareItem(downloadEntry.getPlan().getSoftwareDescription(), downloadEntry.getPath());
            } else {
                String part = m.getApp().substring(2, 3);
                swi = this.swDataProvider.getSoftwareItem(downloadEntry.getPlan().getSoftwareDescription(), part);
                downloadEntry.setPath(part);
            }
            DownloadPlan plan = downloadEntry.getPlan();
            this.appendFwMetaDataToResponse(response, plan.getDownloadTarget(), swi.getLength(), plan.getActivationDate(), swi.getCrc());
            downloadEntry.setStatus(DownloadStatus.IN_PROGRESS);
            if (logger.isTraceEnabled()) {
                int fileSizeInBytes = swi.getLength();
                int numberOfBlocks = (int)Math.ceil((double)fileSizeInBytes / 256.0);
                logger.trace("The data from path '{}', {} bytes long will be send as {} blocks in {} cycles.", new Object[]{downloadEntry.getPath(), fileSizeInBytes, numberOfBlocks, (int)Math.ceil((double)numberOfBlocks / 50.0)});
            }
        } else {
            logger.warn("Requested download item doesn't exist. Sending fake data.");
            this.appendFwMetaDataToResponse(response, this.getTarget(m), 0, LocalDate.now().minusDays(7L), "0000");
        }
    }

    private void appendFwMetaDataToResponse(ServerResponseBuilder response, DownloadTarget dt, int fileSizeInBytes, LocalDate activatDate, String crc) {
        int numberOfBlocks = (int)Math.ceil((double)fileSizeInBytes / 256.0);
        char fwSpecChar = this.getFirmwateTypeSpecificMnemonicLetter(dt);
        response.append(String.format("F%1$cB", Character.valueOf(fwSpecChar)), String.format("%1$04d", numberOfBlocks));
        response.append(String.format("F%1$cS", Character.valueOf(fwSpecChar)), String.format("%1$04d", 50));
        response.append("AFB", String.format("%06X", fileSizeInBytes));
        response.append("DGA", activatDate.format(DGA_TIME_FORMATTER));
        response.append("FCC", crc);
    }

    @Transactional(readOnly=true)
    public void getFilePart(PdmMessageDto m, ServerResponseBuilder response) {
        int[] requiredBlocks = this.parseDownloadOffset(m);
        int[] filePositions = this.calculateFileOffsets(requiredBlocks);
        int filePartStartOffset = filePositions[0];
        int filePartLength = filePositions[1];
        DownloadTarget target = this.getTarget(m);
        Optional downloadEntry = this.getFirmwareDescription(m.getPdm(), this.getTarget(m));
        byte[] filePart = null;
        if (downloadEntry.isPresent()) {
            String part;
            String storagePath = m.getApp() == null || m.getApp().equals("CPU7") ? ((DownloadEntry)downloadEntry.get()).getPath() : (part = m.getApp().substring(2, 3));
            filePart = this.getFilePartData(m.getPdm(), target, filePartStartOffset, filePartLength, storagePath);
        } else {
            filePart = ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        response.setProperty("pdm_number", (Object)m.getPdm().getNumber());
        response.setProperty("first_block", (Object)requiredBlocks[0]);
        response.setProperty("block_size", (Object)256);
        response.setProperty("firmware_type", (Object)String.format("F%cD", Character.valueOf(this.getFirmwateTypeSpecificMnemonicLetter(target))));
        response.append(filePart);
    }

    private DownloadTarget getTarget(PdmMessageDto m) {
        DownloadTarget result = null;
        if (m.getFml() != null || m.getFmd() != null) {
            result = DownloadTarget.MODEM;
        } else if (m.getDlt() != null) {
            switch (m.getDlt()) {
                case 2: {
                    result = DownloadTarget.PRINTER_1;
                    break;
                }
                case 3: {
                    result = DownloadTarget.COIN_SELECTOR_DATA;
                    break;
                }
                case 1: 
                case 4: {
                    result = DownloadTarget.CONFIG;
                    break;
                }
                case 5: {
                    result = DownloadTarget.CARD_READER_1;
                    break;
                }
                default: {
                    logger.error("Meaning of value '{}' in mnemonic DLT is not know and cannot be processed", (Object)m.getDlt());
                    break;
                }
            }
        } else if (m.getApp() != null) {
            result = DownloadTarget.PDM;
        }
        if (result != null) {
            return result;
        }
        throw new UnsupportedOperationException("It is not possible to determinde download type from PDM message.");
    }

    private char getFirmwateTypeSpecificMnemonicLetter(DownloadTarget target) {
        return switch (1.$SwitchMap$de$rtb$pcon$model$download$DownloadTarget[target.ordinal()]) {
            case 1 -> 'M';
            case 2, 3, 4, 5 -> 'D';
            case 6 -> 'X';
            default -> throw new IllegalStateException(String.format("Operation %s is not supported by UDP FW update.", target.toString()));
        };
    }

    private int[] parseDownloadOffset(PdmMessageDto m) {
        String blockRange = null;
        if (m.getFmd() != null) {
            blockRange = m.getFmd();
        } else if (m.getFdd() != null) {
            blockRange = m.getFdd();
        } else if (m.getFxd() != null) {
            blockRange = m.getFxd();
        } else {
            throw new IllegalStateException("None of mnemonics defines required block range");
        }
        try {
            int startBlockNr = Integer.parseInt(blockRange.substring(0, 4));
            int endBlockNr = Integer.parseInt(blockRange.substring(4, 8));
            return new int[]{startBlockNr, endBlockNr};
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Invalid block range %s.", blockRange));
        }
    }

    private int[] calculateFileOffsets(int[] blockRange) {
        int startBlockNr = blockRange[0];
        int endBlockNr = blockRange[1];
        int blockCount = endBlockNr - startBlockNr + 1;
        int filePartStartOffset = (startBlockNr - 1) * 256;
        int filePartLength = blockCount * 256;
        return new int[]{filePartStartOffset, filePartLength};
    }
}

