/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.api.remote_data_acces.ExportApiClearingRepository;
import de.rtb.pcon.api.remote_data_acces.ExportApiPaymentRepository;
import de.rtb.pcon.api.remote_data_acces.ExportApiProperties;
import de.rtb.pcon.api.remote_data_acces.ExportApiStatusRepository;
import de.rtb.pcon.api.remote_data_acces.ExportedCashBoxLevels;
import de.rtb.pcon.api.remote_data_acces.ExportedClearingMessageDao;
import de.rtb.pcon.api.remote_data_acces.ExportedClearingsDao;
import de.rtb.pcon.api.remote_data_acces.ExportedDateToTokenDao;
import de.rtb.pcon.api.remote_data_acces.ExportedMoney;
import de.rtb.pcon.api.remote_data_acces.ExportedPaymentDao;
import de.rtb.pcon.api.remote_data_acces.ExportedPaymentMessageDao;
import de.rtb.pcon.api.remote_data_acces.ExportedPdmCashBoxesDao;
import de.rtb.pcon.api.remote_data_acces.ExportedProjectDao;
import de.rtb.pcon.api.remote_data_acces.ExportedStatusDao;
import de.rtb.pcon.api.remote_data_acces.ExportedStatusMessageDao;
import de.rtb.pcon.api.remote_data_acces.ExpotedCashBoxLevels;
import de.rtb.pcon.core.cash_box.CashBoxMonitorService;
import de.rtb.pcon.core.gdpr.GdprService;
import de.rtb.pcon.model.CashBoxLevel;
import de.rtb.pcon.model.RecentPayment;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/export/v1/"})
class ExportApiController {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private ExportApiProperties apiProps;
    @Autowired
    private ExportApiStatusRepository smRepo;
    @Autowired
    private ExportApiPaymentRepository ptRepo;
    @Autowired
    private ExportApiClearingRepository clRepo;
    @Autowired
    private GdprService gdprService;
    @Autowired
    private CashBoxMonitorService cashBoxMonitorService;
    @Autowired
    private ObjectMapper objectMapper;

    ExportApiController() {
    }

    @GetMapping(value={"status/byOrder"})
    @Operation(summary="Status messages since last request.", description="The method returns continuation token.\nIt is necessary to provide back to continue from the place where it was stopped last time.", tags={"Status"})
    public ExportedStatusDao statusByOrder(@Parameter(description="Continuation token returned by last call.") @RequestParam(value="continuationToken", defaultValue="0") long continuationToken, @Parameter(description="Maximal number of items in response. Hard maximum is set by {pcon.api.export.maxPageSize} property.\nGenerally it is better to read larger chunks (close to maximum 10 000) if you import old data.\nUsually to find old data, takes longer then the send them over network. Recent data are found quicker.", example="10") @RequestParam(value="pageSize", defaultValue="5000") int pageSize) {
        int pageSizeReal = Math.min(this.apiProps.getMaxPageSize(), pageSize);
        PageRequest pageRequest = PageRequest.of((int)0, (int)pageSizeReal);
        Slice dataSlice = this.smRepo.findByPdmInAndIdGreaterThanOrderById((Collection)this.securityService.getCurrentPdms(), continuationToken, (Pageable)pageRequest);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        List data = dataSlice.getContent();
        long lastId = data.isEmpty() ? 0L : ((StatusMessage)data.get(data.size() - 1)).getId();
        return new ExportedStatusDao(Long.toString(lastId), data.stream().map(sm -> new ExportedStatusMessageDao(sm, timeZone)).toList(), dataSlice.hasNext());
    }

    @GetMapping(value={"status/findToken"})
    @Operation(summary="Find first continuation token after provided time instant.", description="It can be used to export status messages after particular date and time instead from the beginning.\nThis method can be slow especially for deeper past. Do not use it regularly.\nIt should be used once as the export process is initiated.", tags={"Status"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="422", description="Provided date and time is not parsable.", content={@Content})})
    public ResponseEntity<ExportedDateToTokenDao> statusTokenFind(@Parameter(description="Local date and time in user time zone after to search.\nRequired ISO 8601 format.", example="2021-04-20T11:53") @RequestParam(value="date") String parlocalDateTime) {
        ZoneId timeZone = this.i18n.userTimeZoneId();
        try {
            LocalDateTime searchAfterLoc = LocalDateTime.parse(parlocalDateTime);
            OffsetDateTime searchAfterOffset = DateTimeUtils.toOffsetDateTime((LocalDateTime)searchAfterLoc, (ZoneId)timeZone);
            ExportedDateToTokenDao result = this.smRepo.findTop1ByPdmInAndPdmTimeAfterOrderByPdmTimeAsc((Collection)this.securityService.getCurrentPdms(), searchAfterOffset).map(sm -> new ExportedDateToTokenDao(searchAfterLoc, DateTimeUtils.toLocalDateTime((OffsetDateTime)sm.getPdmTime(), (ZoneId)timeZone), Long.valueOf(sm.getId() - 1L))).orElseGet(() -> new ExportedDateToTokenDao(searchAfterLoc));
            return ResponseEntity.ok((Object)result);
        }
        catch (DateTimeParseException e) {
            return ResponseEntity.unprocessableEntity().build();
        }
    }

    @GetMapping(value={"payments/byOrder"})
    @Operation(summary="Payment messages since last request.", description="The method returns continuation token.\nIt is necessary to provide it back to continue from the place where it was stopped last time.", tags={"Payment"})
    public ExportedPaymentDao paymentsByOrder(@Parameter(description="Continuation token returned by last call.") @RequestParam(value="continuationToken", required=false, defaultValue="0") long continuationToken, @Parameter(description="Maximal number of items in response.\nGenerally it is better to read larger chunks (close to maximum 10 000) if you import old data.\nUsually to find old data takes longer then the send them over network. Recent data are found quicker.", example="10") @RequestParam(value="pageSize", defaultValue="5000") Integer pageSize) {
        int pageSizeReal = Math.min(this.apiProps.getMaxPageSize(), pageSize);
        PageRequest pageRequest = PageRequest.of((int)0, (int)pageSizeReal);
        Slice dataSlice = this.ptRepo.findNextPayments((Collection)this.securityService.getCurrentPdms(), continuationToken, (Pageable)pageRequest);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        boolean isEconomist = this.securityService.hasRole(UserRole.ROLE_PCON_ECONOMIST);
        List data = dataSlice.getContent();
        long lastId = data.isEmpty() ? 0L : ((RecentPayment)data.get(data.size() - 1)).getId();
        boolean isLpnProtected = this.gdprService.isLpnProtected();
        return new ExportedPaymentDao(Long.toString(lastId), data.stream().map(pq -> new ExportedPaymentMessageDao(pq.getId(), pq.getPayment(), timeZone, isEconomist, isLpnProtected, this.objectMapper)).toList(), dataSlice.hasNext());
    }

    @GetMapping(value={"payments/findToken"})
    @Operation(summary="Find first continuation token after provided time instant.", description="It can be used to export payment messages after particular date and time instead from the beginning.\nThis method can be slow especially for deeper past. Do not use it regularly.\nIt should be used once as the export process is initiated.", tags={"Payment"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="422", description="Provided date and time is not parsable.", content={@Content})})
    public ResponseEntity<ExportedDateToTokenDao> paymentTokenFind(@Parameter(description="Local date and time in user time zone after to search.\nRequired ISO 8601 format.", example="2021-04-20T11:53") @RequestParam(value="date") String parlocalDateTime) {
        ZoneId timeZone = this.i18n.userTimeZoneId();
        try {
            LocalDateTime searchAfterLoc = LocalDateTime.parse(parlocalDateTime);
            OffsetDateTime searchAfterOffset = DateTimeUtils.toOffsetDateTime((LocalDateTime)searchAfterLoc, (ZoneId)timeZone);
            ExportedDateToTokenDao result = this.ptRepo.findTokenByDate((Collection)this.securityService.getCurrentPdms(), searchAfterOffset).map(pt -> new ExportedDateToTokenDao(searchAfterLoc, DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getPayment().getId().getPdmTime(), (ZoneId)timeZone), Long.valueOf(pt.getId() - 1L))).orElseGet(() -> new ExportedDateToTokenDao(searchAfterLoc));
            return ResponseEntity.ok((Object)result);
        }
        catch (DateTimeParseException e) {
            return ResponseEntity.unprocessableEntity().build();
        }
    }

    @GetMapping(value={"clearings/byOrder"})
    @Operation(summary="Clearings messages since last request.", description="The method returns continuation token.\nIt is necessary to provide it back to continue from the place where it was stopped last time.", tags={"Clearing"})
    public ExportedClearingsDao clearingsByOrder(@Parameter(description="Continuation token returned by last call.") @RequestParam(value="continuationToken", required=false, defaultValue="0") long continuationToken, @Parameter(description="Maximal number of items in response.\nGenerally it is better to read larger chunks (close to maximum 10 000) if you import old data.\nUsually to find old data takes longer then the send them over network. Recent data are found quicker.", example="10") @RequestParam(value="pageSize", defaultValue="5000") Integer pageSize) {
        int pageSizeReal = Math.min(this.apiProps.getMaxPageSize(), pageSize);
        PageRequest pageRequest = PageRequest.of((int)0, (int)pageSizeReal);
        Slice dataSlice = this.clRepo.findByPdmInAndIdGreaterThanOrderById((Collection)this.securityService.getCurrentPdms(), continuationToken, (Pageable)pageRequest);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        boolean isEconomist = this.securityService.hasRole(UserRole.ROLE_PCON_ECONOMIST);
        List data = dataSlice.getContent();
        long lastId = data.isEmpty() ? 0L : ((Clearing)data.get(data.size() - 1)).getId();
        ExportedClearingsDao result = new ExportedClearingsDao();
        result.setHasMore(dataSlice.hasNext());
        result.setContinuationToken(Long.toString(lastId));
        result.setClearings(data.stream().map(pt -> new ExportedClearingMessageDao(pt, timeZone, isEconomist)).toList());
        return result;
    }

    @GetMapping(value={"clearings/findToken"})
    @Operation(summary="Find first continuation token after provided time instant.", description="It can be used to export payment messages after particular date and time instead from the beginning.\nThis method can be slow especially for deeper past. Do not use it regularly.\nIt should be used once as the export process is initiated.", tags={"Clearing"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="422", description="Provided date and time is not parsable.", content={@Content})})
    public ResponseEntity<ExportedDateToTokenDao> clearingTokenFind(@Parameter(description="Local date and time in user time zone after to search.\nRequired ISO 8601 format.", example="2021-04-20T11:53") @RequestParam(value="date") String parlocalDateTime) {
        ZoneId timeZone = this.i18n.userTimeZoneId();
        try {
            LocalDateTime searchAfterLoc = LocalDateTime.parse(parlocalDateTime);
            OffsetDateTime searchAfterOffset = DateTimeUtils.toOffsetDateTime((LocalDateTime)searchAfterLoc, (ZoneId)timeZone);
            ExportedDateToTokenDao result = this.clRepo.findTop1ByPdmInAndPdmTimeAfterOrderByPdmTimeAsc((Collection)this.securityService.getCurrentPdms(), searchAfterOffset).map(pt -> new ExportedDateToTokenDao(searchAfterLoc, DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getPdmTime(), (ZoneId)timeZone), Long.valueOf(pt.getId() - 1L))).orElseGet(() -> new ExportedDateToTokenDao(searchAfterLoc));
            return ResponseEntity.ok((Object)result);
        }
        catch (DateTimeParseException e) {
            return ResponseEntity.unprocessableEntity().build();
        }
    }

    @GetMapping(value={"project"})
    @Transactional(readOnly=true)
    @Operation(summary="Project configuration.", description="Tree of areas and PDMs accessible by current user.", tags={"Project"})
    public ExportedProjectDao areaXml() {
        List areas = this.securityService.getCurrentAreas();
        return new ExportedProjectDao((Collection)areas);
    }

    @GetMapping(value={"cashBoxes"})
    @Transactional(readOnly=true)
    @Operation(summary="Cash box levels of all PDMs.", description="Provides information about amount of money in cash box.\nPlease note, that there may be multiple cash boxes in the PDM and each of them can contain multiple currencies.", tags={"Payment"})
    public ExportedCashBoxLevels cashboxLevels() {
        List pdms = this.securityService.getCurrentPdms();
        List cachBoxLevels = this.cashBoxMonitorService.findForPdms((Collection)pdms);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        boolean isEconomist = this.securityService.hasRole(UserRole.ROLE_PCON_ECONOMIST);
        TreeMap<Integer, ExportedPdmCashBoxesDao> m = new TreeMap<Integer, ExportedPdmCashBoxesDao>();
        for (CashBoxLevel l : cachBoxLevels) {
            ExpotedCashBoxLevels mePaymentType;
            ExportedPdmCashBoxesDao mePdm = m.computeIfAbsent(l.getPdm().getId(), k -> new ExportedPdmCashBoxesDao(l.getPdm().getId()));
            Optional<ExpotedCashBoxLevels> mePaymentTypeO = mePdm.getCashBoxes().stream().filter(pl -> l.getPaymentType().equals((Object)pl.getType())).findAny();
            if (mePaymentTypeO.isEmpty()) {
                mePaymentType = new ExpotedCashBoxLevels(l.getPaymentType(), DateTimeUtils.toLocalDateTime((OffsetDateTime)l.getLastClearing(), (ZoneId)timeZone));
                mePdm.getCashBoxes().add(mePaymentType);
            } else {
                mePaymentType = mePaymentTypeO.get();
            }
            mePaymentType.getLevels().add(new ExportedMoney(isEconomist ? l.getLevel() : null, l.getCurrency()));
        }
        return new ExportedCashBoxLevels(m.values().stream().toList());
    }
}

