/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1.dao;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitValidatedDao;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcontrol.utils.DateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

@Schema(name="PermitBasic", description="Basic information about parking permit start and end.", subTypes={EnfPermitValidatedDao.class})
public class EnfPermitBasicDao {
    @Schema(description="Id of the paring permit.")
    @JacksonXmlProperty(isAttribute=true)
    private Long id = null;
    @Schema(description="Beginning of validity.", example="2020-05-17T14:58")
    private LocalDateTime from;
    @Schema(description="End of validity.", example="2020-05-17T16:18")
    private LocalDateTime to;
    @Schema(description="Car's license plate", example="PB12345")
    private String lpn;
    @Schema(description="Occupied parking place", example="A35")
    private String psn;

    public EnfPermitBasicDao(PaymentTransaction pt, ZoneId timeZone, boolean canViewLpn) {
        this.from = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getId().getPdmTime(), (ZoneId)timeZone);
        this.to = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getParkEndTime(), (ZoneId)timeZone);
        this.lpn = pt.getLpn();
        this.psn = pt.getPsn() == null ? null : Integer.toString(pt.getPsn());
    }

    public Long getId() {
        return this.id;
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public String getLpn() {
        return this.lpn;
    }

    public String getPsn() {
        return this.psn;
    }
}

