/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import com.fasterxml.jackson.annotation.JsonGetter;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueBySummaryDto;
import de.rtb.pcon.ui.controllers.reports.revenue.UiAmountCount;
import de.rtb.pcon.ui.controllers.reports.revenue.UiSummaryRow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;

class UiSummaryReport {
    private List<UiSummaryRow> rows = new ArrayList();

    UiSummaryReport() {
    }

    public static UiSummaryReport fromDm(Collection<RevenueBySummaryDto> dmRows) {
        UiSummaryReport report = new UiSummaryReport();
        for (RevenueBySummaryDto dbr : dmRows) {
            UiSummaryRow rRow = report.getRows().stream().filter(r -> r.getPdmId() == (long)dbr.getPdm().getId().intValue()).findAny().orElseGet(() -> report.createReportRow(dbr));
            UiAmountCount item = rRow.createItem(dbr.getPaymentType());
            item.setAmount(dbr.getAmount());
            item.setCount(dbr.getNrOfPayments());
        }
        return report;
    }

    public UiSummaryRow createReportRow(RevenueBySummaryDto dbRow) {
        UiSummaryRow row = new UiSummaryRow(this);
        row.setPdmId((long)dbRow.getPdm().getId().intValue());
        row.setPdmName(dbRow.getPdm().getName());
        row.setPdmNumber(dbRow.getPdm().getNumber().intValue());
        row.setCurrency(dbRow.getCurrency());
        row.setItems(new EnumMap(PaymentType.class));
        this.rows.add(row);
        return row;
    }

    public Integer periodCount(String currency, PaymentType paymentType) {
        return this.rows.stream().filter(row -> currency.equals(row.getCurrency())).map(row -> row.getItem(paymentType).getCount()).reduce(0, Integer::sum);
    }

    public BigDecimal periodAmount(String currency, PaymentType paymentType) {
        return this.rows.stream().filter(row -> currency.equals(row.getCurrency())).map(row -> row.getItem(paymentType).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Integer periodTotalCount(String currency) {
        return this.rows.stream().filter(row -> currency.equals(row.getCurrency())).map(UiSummaryRow::getTotalCount).reduce(0, Integer::sum);
    }

    public BigDecimal periodTotalAmount(String currency) {
        return this.rows.stream().filter(row -> currency.equals(row.getCurrency())).map(UiSummaryRow::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public List<PaymentType> getPaymentTypes() {
        HashSet paymentTypes = new HashSet();
        for (UiSummaryRow r : this.rows) {
            paymentTypes.addAll(r.getItems().keySet());
        }
        return paymentTypes.stream().sorted().toList();
    }

    @JsonGetter(value="paymentTypes")
    public List<Integer> getPaymentTypesJson() {
        return this.getPaymentTypes().stream().map(PaymentType::getValue).toList();
    }

    public List<UiSummaryRow> getRows() {
        return this.rows;
    }

    public void setRows(List<UiSummaryRow> report) {
        this.rows = report;
    }
}

