/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.SystemController;
import de.rtb.pcon.ui.controllers.model.UiUserFull;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/system/"})
public class SystemController {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityService securityService;
    @Autowired(required=false)
    private BuildProperties buildProperties;

    @GetMapping(value={"version"})
    public UiSystemVersion getVersion() {
        String buildNumber;
        if (this.buildProperties == null) {
            UiSystemVersion ver = new UiSystemVersion();
            ver.setTest(true);
            return ver;
        }
        UiSystemVersion uiversion = new UiSystemVersion();
        String pomVersion = this.buildProperties.getVersion();
        if (StringUtils.isNotBlank((CharSequence)pomVersion)) {
            String verNumber = StringUtils.substringBefore((String)this.buildProperties.getVersion(), (String)"-");
            String verSuffix = StringUtils.substringAfter((String)this.buildProperties.getVersion(), (String)"-");
            uiversion.setVersion(verNumber);
            uiversion.setTest(StringUtils.isNotBlank((CharSequence)verSuffix));
        } else {
            uiversion.setTest(true);
        }
        uiversion.setVcsHash(this.buildProperties.get("scm.changesescm.changeset.sha.short"));
        String buildUrl = this.buildProperties.get("ci.pipeline.url");
        if (StringUtils.isNotBlank((CharSequence)buildUrl) && !"N/A".equals(buildUrl)) {
            uiversion.setCiLink(buildUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(buildNumber = this.buildProperties.get("ci.pipeline.id"))) && !"N/A".equals(buildNumber)) {
            uiversion.setCiBuildNumber(buildNumber);
        }
        return uiversion;
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"user"})
    @Transactional(readOnly=true)
    public UiUserFull getUser() {
        String userLogin = this.securityService.getCurrentUserLogin();
        User user = (User)this.entityManager.createQuery("from User where login = :login", User.class).setParameter("login", (Object)userLogin).getSingleResult();
        return new UiUserFull(user);
    }
}

