/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.easy_park;

import de.rtb.pcon.core.notification.NotificationService;
import de.rtb.pcon.features.partners.PartnerTransportTask;
import de.rtb.pcon.features.partners.PartnerUtils;
import de.rtb.pcon.features.partners.easy_park.EpAuthService;
import de.rtb.pcon.features.partners.easy_park.EpConfigDto;
import de.rtb.pcon.features.partners.easy_park.EpConfigZone;
import de.rtb.pcon.features.partners.easy_park.EpImportRequest;
import de.rtb.pcon.features.partners.easy_park.EpImportResponse;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Scope(value="prototype")
class EpImportPaymentTask
implements PartnerTransportTask {
    private static final Logger log = LoggerFactory.getLogger(EpImportPaymentTask.class);
    private EpConfigDto config;
    private final PaymentTransaction payment;
    @Autowired
    @Qualifier(value="rt3rdPartyApi")
    private RestTemplate restTemplate;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private EpAuthService epAuthService;

    public EpImportPaymentTask(EpConfigDto config, PaymentTransaction payment) {
        this.config = config;
        this.payment = payment;
    }

    public void run() {
        this.config.zones().stream().filter(z -> this.payment.getId().getPdm().getZone().getId().equals(z.rtbId())).findAny().filter(epz -> epz.areaNo() != null).ifPresentOrElse(arg_0 -> this.regiserPayment(arg_0), () -> this.sendZoneNotAvailableErrorMail());
    }

    void regiserPayment(EpConfigZone epZone) {
        EpImportRequest epImportRequest = this.createImportRequest(epZone);
        try {
            EpImportResponse epImportResponse = this.importPayment(epImportRequest);
            if (epImportResponse == null) {
                log.atError().setMessage("Null response from EasyPark! Request: {}").addArgument((Object)PartnerUtils.toJsonLikeString((Object)this.payment, (boolean)false)).log();
                this.sendEmail("Null response from EasyPark", PartnerUtils.composePaymentRegistrationErrorMessageBody(null, (PaymentTransaction)this.payment, (Object)epImportRequest, (Object)epImportResponse, (String)"EasyPark returned null answer."));
                return;
            }
            if ("SUCCESS_OK".equals(epImportResponse.getStatus())) {
                log.atInfo().setMessage("Payment #{}, on behalf of {} in areaNo'{}', registered to EasyPark ({}).").addArgument((Object)this.payment.getId()).addArgument(() -> LoggerUtils.log((Zone)this.payment.getId().getPdm().getZone())).addArgument((Object)epZone.areaNo()).addArgument((Object)this.config.general().urlBase()).log();
            } else {
                if (log.isErrorEnabled()) {
                    log.error("Payment #{} registration by EasyPark failed: '{}' UserError: {}, TechError: {}).", new Object[]{this.payment.getId(), epImportResponse.getStatus(), epImportResponse.getUserErrorString(), epImportResponse.getTechErrorString()});
                }
                this.sendEmail("EasyPark rejected payment registration", PartnerUtils.composePaymentRegistrationErrorMessageBody(null, (PaymentTransaction)this.payment, (Object)epImportRequest, (Object)epImportResponse, null));
            }
        }
        catch (Exception e) {
            log.atError().setMessage("Fail to register payment to EasyPark: {}").addArgument((Object)PartnerUtils.toJsonLikeString((Object)this.payment, (boolean)false)).setCause((Throwable)e).log();
            this.sendEmail("Error by submitting payment to EasyPark", PartnerUtils.composePaymentRegistrationErrorMessageBody((Exception)e, (PaymentTransaction)this.payment, (Object)epImportRequest, null, null));
        }
    }

    void sendZoneNotAvailableErrorMail() {
        this.sendEmail("Zone is not eligible for Easy Park", MessageFormat.format("# Failed to register payment!\n\n **Payment**\n{0}\n\n**Reason**\n.{1} is not configured properly.", PartnerUtils.toJsonLikeString((Object)this.payment, (boolean)true), StringUtils.capitalize((String)LoggerUtils.log((Zone)this.payment.getId().getPdm().getZone()))));
    }

    public EpImportRequest createImportRequest(EpConfigZone epZone) {
        EpImportRequest importRequets = new EpImportRequest();
        importRequets.setExternalParkingId("RTB-" + String.valueOf(this.payment.getId()));
        importRequets.setAreaNo(epZone.areaNo());
        importRequets.setAreaCountryCode(this.config.general().countryCode());
        importRequets.setStartDate(this.payment.getId().getPdmTime());
        importRequets.setEndDate(this.payment.getParkEndTime());
        importRequets.setLicenseNumber(this.payment.getLpn());
        importRequets.setSubType("NORMAL_TIME");
        importRequets.setParkingFeeInclusiveVAT(this.payment.getAmount());
        importRequets.setParkingFeeVAT(this.config.general().vat());
        importRequets.setCurrency(this.payment.getCurrency());
        return importRequets;
    }

    @Nullable
    public EpImportResponse importPayment(EpImportRequest body) {
        URI reqUri = UriComponentsBuilder.fromUriString((String)this.config.general().urlBase()).pathSegment(new String[]{"rest", "resources", "external-api", "parkings", "import"}).build().encode().toUri();
        Area area = this.payment.getId().getPdm().getZone().getArea();
        RequestEntity reqEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)reqUri).accept(new MediaType[]{MediaType.APPLICATION_JSON})).header("X-Authorization", new String[]{this.epAuthService.provideAuthHeaderContent(area)})).body((Object)body);
        return (EpImportResponse)this.restTemplate.postForObject(reqUri, (Object)reqEntity, EpImportResponse.class);
    }

    void sendEmail(String subject, String body) {
        if (StringUtils.isNotBlank((CharSequence)this.config.errorEmail())) {
            this.notificationService.sendEmail(this.config.errorEmail(), subject, body + this.signature());
        } else {
            log.warn("EasyPark registration failure e-mail was not sent, because notification e-mail is not defined in configuration.");
        }
    }

    public void sendTaksRejectedEmail() {
        this.sendEmail("Task rejected from executor.", "#Task for payment registration was rejected from executor!\n\nPayment\n%s".formatted(PartnerUtils.toJsonLikeString((Object)this.payment, (boolean)true)));
    }
}

