/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.card_id;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.card_id.BonIdBonusInfoDtoPdm;
import de.rtb.pcon.features.bonus.card_id.BonIdRequestDto;
import de.rtb.pcon.features.bonus.card_id.BonIdRuleEntity;
import de.rtb.pcon.features.bonus.card_id.BonIdRuleRepository;
import de.rtb.pcon.model.Pdm;
import java.time.ZoneId;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonIdRtrIdRecordUsage
implements RealTimeRequest {
    @Autowired
    private BonIdRuleRepository bonusRuleRepo;

    BonIdRtrIdRecordUsage() {
    }

    public int getId() {
        return 52;
    }

    public String getDescription() {
        return "ID bonus, record usage";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        BonIdRequestDto bonusRequest = (BonIdRequestDto)ctx.getLocalObject("BID", BonIdRequestDto.class);
        Integer numberOfUsage = ctx.getLocalIntegerO("used").orElse(1);
        Pdm pdm = ctx.findPdmEntity();
        ZoneId pdmTimeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        return this.bonusRuleRepo.findByKeyAndTypeZoneAndTypeName(bonusRequest.getKey(), pdm.getZone(), bonusRequest.getType()).map(b -> {
            b.setUsedTimes(Integer.valueOf(b.getUsedTimes() + numberOfUsage));
            return Map.of("bonus", BonIdBonusInfoDtoPdm.fromEntity((BonIdRuleEntity)b, (ZoneId)pdmTimeZone));
        }).orElse(Map.of());
    }
}

