/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_1;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1Service;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonBasic1RtrOffer
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonBasic1RtrOffer.class);
    @Autowired
    private BonBasic1Service bonusService;

    BonBasic1RtrOffer() {
    }

    public int getId() {
        return 16;
    }

    public String getDescription() {
        return "LPN basic bonus 1, provide";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        HashedMap result = new HashedMap();
        String lcn = ctx.getLicensePlate();
        if (StringUtils.isBlank((CharSequence)lcn)) {
            log.error("Bonus cannot be provided because license plate number is unknown.");
            return result;
        }
        this.bonusService.findBonusValue(ctx.findPdmEntity(), lcn).ifPresent(bc -> {
            if (!bc.getDuration().isZero()) {
                result.put((Object)"BOT", (Object)bc.getDuration().toMinutes());
            }
            if (BigDecimal.ZERO.compareTo(bc.getPrice()) != 0) {
                result.put((Object)"BOA", (Object)bc.getPrice().scaleByPowerOfTen(ctx.getMonetaryScale()));
            }
        });
        return result;
    }
}

