/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.repositories.UserRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScalableResourcesConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ScalableResourcesConfigurationService.class);
    private final int cpuCount;
    private final long heapCurrent;
    private final long heapMax;
    public final int tpAssemblerThreads;
    public final int tpAssemblerQueue;
    public final int tpMainThreads;
    public final int tpMainQueue;
    public final int guardFwUpdateThreads;
    public final int guardBlockingApiThreads;
    public final int tpForeignRegisterThreads;
    public final int tpForeignRegisterQueue;
    public final int crUiLogbookInit;
    public final int crUiLogbookMax;
    public final int crAareaServicesInit;
    public final int crAareaServicesMax;
    public final int crTracerGuardInit;
    public final int crTracerGuardMax;
    public final int crLastVoltageInit;
    public final int crLastVoltageMax;
    public final int crFwdRulesInit;
    public final int crFwdRulesMax;
    public final int crAreaPartnersInit;
    public final int crAreaPartnersMax;

    public ScalableResourcesConfigurationService(PdmRepository pdmRepo, UserRepository userRepo, DevelopmentProperties devProps) {
        if (devProps.isVirtualThreads()) {
            log.info("Using virtual threads instead of platform ones!");
        }
        Runtime runtime = Runtime.getRuntime();
        int detectedCpuCount = this.adjustCpuCount(runtime.availableProcessors());
        if (devProps.getCpuCount() < 0) {
            this.cpuCount = detectedCpuCount;
        } else {
            this.cpuCount = devProps.getCpuCount();
            log.warn("CPU count is overridden by user to {} (detected {}). Performance may not be optimal!", (Object)this.cpuCount, (Object)detectedCpuCount);
        }
        this.heapCurrent = runtime.totalMemory();
        this.heapMax = runtime.maxMemory();
        if (log.isInfoEnabled()) {
            log.info("Detected {} CPUs, heap size current {} MB, maximal {} MB.", new Object[]{this.cpuCount, this.heapCurrent / 0x100000L, this.heapMax / 0x100000L});
            long pdmCount = pdmRepo.count();
            long userCount = userRepo.count();
            log.info("There is {} PDMs and {} users.", (Object)pdmCount, (Object)userCount);
        }
        this.tpAssemblerThreads = Math.max(2, this.cpuCount * 2);
        this.tpAssemblerQueue = 5 * this.tpAssemblerThreads;
        this.tpMainThreads = Math.max(4, 50 * this.cpuCount);
        this.tpMainQueue = 2 * this.tpMainThreads;
        this.guardFwUpdateThreads = Math.max(1, this.tpMainThreads / 4);
        this.guardBlockingApiThreads = Math.max(1, this.tpMainThreads / 4);
        this.tpForeignRegisterThreads = Math.max(1, 3 * this.cpuCount);
        this.tpForeignRegisterQueue = Math.max(10, 20 * this.tpForeignRegisterThreads);
        this.crUiLogbookInit = 5;
        this.crUiLogbookMax = 30;
        this.crAareaServicesInit = 0;
        this.crAareaServicesMax = 30;
        this.crTracerGuardInit = 100;
        this.crTracerGuardMax = 10000;
        this.crLastVoltageInit = 100;
        this.crLastVoltageMax = 1000;
        this.crFwdRulesInit = 100;
        this.crFwdRulesMax = 1000;
        this.crAreaPartnersInit = 100;
        this.crAreaPartnersMax = 1000;
        this.printResourceConfiguration();
    }

    public void printResourceConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug("Main task executor: {} threads, queue {} items.", (Object)this.tpMainThreads, (Object)this.tpMainQueue);
            log.debug(" + Limits: {} threads for FW update, {} thread for 3rd party API.", (Object)this.guardFwUpdateThreads, (Object)this.guardBlockingApiThreads);
            log.debug("TCP assembler task executor: {} threads, queue {} items.", (Object)this.tpAssemblerThreads, (Object)this.tpAssemblerQueue);
            log.debug("Payment Foreign Register task executor: {} threads, queue {} items.", (Object)this.tpForeignRegisterThreads, (Object)this.tpForeignRegisterQueue);
            log.debug("Cache regions: ");
            log.debug(" + Log-book: {} / {}", (Object)this.crUiLogbookInit, (Object)this.crUiLogbookMax);
            log.debug(" + AreaService: {} / {}", (Object)this.crAareaServicesInit, (Object)this.crAareaServicesMax);
            log.debug(" + Tracer guard: {} / {}", (Object)this.crTracerGuardInit, (Object)this.crTracerGuardMax);
            log.debug(" + Last voltage: {} / {}", (Object)this.crLastVoltageInit, (Object)this.crLastVoltageMax);
            log.debug(" + Forwarding rules: {} / {}", (Object)this.crFwdRulesInit, (Object)this.crFwdRulesMax);
        }
    }

    private int adjustCpuCount(int osCpuCount) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Math.max(osCpuCount / 2, 1);
        }
        return osCpuCount;
    }
}

