/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.real_time_request;

import de.rtb.pcon.core.real_time_request.RealTimeRequestException;

public final class RealTimeRequestParameterException
extends RealTimeRequestException {
    private final String mnemonic;
    private final Object value;

    public RealTimeRequestParameterException(String mnemonic, String message) {
        super(message);
        this.mnemonic = mnemonic;
        this.value = null;
    }

    public RealTimeRequestParameterException(String message) {
        super(message);
        this.mnemonic = null;
        this.value = null;
    }

    public RealTimeRequestParameterException(String mnemonic, String message, Throwable cause) {
        super(message, cause);
        this.mnemonic = mnemonic;
        this.value = null;
    }

    public RealTimeRequestParameterException(String name, Object value, String message, Throwable cause) {
        super(message, cause);
        this.mnemonic = name;
        this.value = value;
    }

    public static final RealTimeRequestParameterException ofClassNotConvertible(String mnemonic, Object value, Class<?> clazz, Throwable cause) {
        return new RealTimeRequestParameterException(mnemonic, value, "Can not convert value of mnemonic '" + mnemonic + "' to '" + clazz.getName() + "'. Value '" + String.valueOf(value) + "'", cause);
    }

    public static final RealTimeRequestParameterException ofValueIsNotAvailable(String mnemonic) {
        return new RealTimeRequestParameterException(mnemonic, "Value of mnemonic '" + mnemonic + "' is not available");
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public Object getValue() {
        return this.value;
    }
}

