/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.open_messages;

import de.rtb.pcon.core.open_messages.OpenMessagesRepo;
import de.rtb.pcon.core.open_messages.OpenMessagesService;
import de.rtb.pcon.model.MessageConfigDefault;
import de.rtb.pcon.model.MessageConfigUser;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.repositories.PdmStatusRepository;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Tuple;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpenMessagesService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private OpenMessagesRepo openMsgRepo;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private PdmStatusRepository stautsRepo;

    public Map<Pdm, List<UiStatusMessage>> listUiOpenMessages(Collection<Integer> pdmIds) {
        boolean canConfirmAllStatusees = this.securityService.hasRole(UserRole.ROLE_PCON_CONFIRM_STATUS);
        List statusees = this.openMsgRepo.listOpenMessageTupples(pdmIds);
        HashMap<Pdm, List<UiStatusMessage>> result = new HashMap<Pdm, List<UiStatusMessage>>();
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        for (Tuple tuple : statusees) {
            PdmStatus pdmStatus = (PdmStatus)tuple.get(0, PdmStatus.class);
            MessageConfigUser mcu = (MessageConfigUser)tuple.get(2, MessageConfigUser.class);
            List omSet = result.computeIfAbsent(pdmStatus.getPdm(), p -> new LinkedList());
            UiStatusMessage uiOm = new UiStatusMessage(pdmStatus, mcu, userTimeZone);
            if (canConfirmAllStatusees) {
                uiOm.setManual(true);
            }
            omSet.add(uiOm);
        }
        return result;
    }

    @Transactional
    public SolveMessageResult solveMessage(int pdmId, short msgNr) {
        List openMessageList = this.openMsgRepo.listOpenMessageTupples(List.of(Integer.valueOf(pdmId)));
        if (CollectionUtils.isEmpty((Collection)openMessageList)) {
            return SolveMessageResult.NOT_OPEN;
        }
        Optional<Tuple> omo = openMessageList.stream().filter(t -> {
            MessageConfigDefault mcd = (MessageConfigDefault)t.get(1, MessageConfigDefault.class);
            return mcd.getNumber() == msgNr;
        }).findFirst();
        if (!omo.isPresent()) {
            return SolveMessageResult.NOT_OPEN;
        }
        Tuple tuple = omo.get();
        PdmStatus pdmStatus = (PdmStatus)tuple.get(0, PdmStatus.class);
        MessageConfigDefault mcd = (MessageConfigDefault)tuple.get(1, MessageConfigDefault.class);
        MessageConfigUser mcu = (MessageConfigUser)tuple.get(2, MessageConfigUser.class);
        boolean canBeSolved = this.securityService.hasRole(UserRole.ROLE_PCON_CONFIRM_STATUS);
        if (!canBeSolved) {
            canBeSolved = mcu == null ? mcd.isManual() : mcu.isManual();
        }
        if (!canBeSolved) {
            return SolveMessageResult.LOCKED;
        }
        this.openMsgRepo.deleteOpenMessage(pdmStatus);
        return SolveMessageResult.DONE;
    }

    @Transactional
    public SolveMessageResult acquireMessage(Pdm pdm, short msgNr) {
        Optional ms = this.stautsRepo.findByPdmAndMessageConfigNumber(pdm, msgNr);
        if (ms.isPresent()) {
            ((PdmStatus)ms.get()).setAcquirer(this.securityService.getCurrentUser());
            return SolveMessageResult.DONE;
        }
        return SolveMessageResult.NOT_OPEN;
    }

    @Transactional
    public SolveMessageResult releaseMessage(Pdm pdm, short msgNr) {
        Optional ms = this.stautsRepo.findByPdmAndMessageConfigNumber(pdm, msgNr);
        if (ms.isPresent()) {
            ((PdmStatus)ms.get()).setAcquirer(null);
            return SolveMessageResult.DONE;
        }
        return SolveMessageResult.NOT_OPEN;
    }
}

