/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(prefix="pcon.mail.notification")
class NotificationProps {
    public static final String STATIC_RESOURCES_URL_PATH = "/res/notification";
    public static final String NOTIFICATION_RESOURCE_LOCATION = "classpath:/mail";
    private String templatePath;
    @DataSizeUnit(value=DataUnit.MEGABYTES)
    private DataSize maxAttachmentSize;

    public NotificationProps(String templatePath, DataSize maxAttachmentSize) {
        this.templatePath = templatePath;
        this.maxAttachmentSize = Objects.requireNonNullElse(maxAttachmentSize, DataSize.ofMegabytes((long)2L));
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public DataSize getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }
}

