/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import de.rtb.pcon.api.remote_data_acces.ExportedMoney;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcontrol.utils.DateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
@Schema(name="Payment", description="Payment message generated by PDM.")
class ExportedPaymentMessageDao {
    @JsonIgnore
    private static final TypeReference<HashMap<String, Object>> USER_DATA_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    @Schema(description="Payment unique identification.")
    @JacksonXmlProperty(isAttribute=true)
    private Long id;
    @Schema(description="Unique identification of PDM which mediated payment.")
    @JacksonXmlProperty(localName="pdm", isAttribute=true)
    private Integer pdmId;
    @Schema(description="Amount of money spent by this payment")
    private ExportedMoney price;
    @Schema(description="Time instant from which is parking ticket valid (in local time zone)")
    private LocalDateTime validFrom;
    @Schema(description="Time instant when is parking ticket validity ends (in local time zone)")
    private LocalDateTime validTo;
    @Schema(description="Time instant when the message was received by server")
    private LocalDateTime recieved;
    @Schema(description="Tracer number")
    private int tracer;
    @Schema(description="Ticket number generated by PDM")
    private int ticketNr;
    @Schema(description="Reason why customer paid")
    private PaymentReason reason;
    @Schema(description="Means of payments")
    private PaymentType type;
    @Schema(description="Name of tariff used by selling the parking permit")
    private String tariff;
    @Schema(description="Car's license plate number")
    @JsonProperty(value="carLicense")
    private String lpn;
    @Schema(description="User data")
    @JsonProperty(value="data")
    private Map<String, Object> userData;

    public ExportedPaymentMessageDao(Long id, PaymentTransaction pt, ZoneId timeZone, boolean exporMoney, boolean protectGdprFields, ObjectMapper objectMapper) {
        this.id = id;
        this.pdmId = pt.getId().getPdm().getId();
        if (exporMoney) {
            this.price = new ExportedMoney(pt.getAmount(), pt.getCurrency());
        }
        this.validFrom = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getId().getPdmTime(), (ZoneId)timeZone);
        this.validTo = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getParkEndTime(), (ZoneId)timeZone);
        this.recieved = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getServerTime(), (ZoneId)timeZone);
        this.tracer = pt.getTracerNumber();
        this.ticketNr = pt.getTicketNumber();
        this.reason = pt.getPaymentReason();
        this.type = pt.getPaymentType();
        this.tariff = Optional.ofNullable(pt.getTariffInfo()).map(TariffInfo::getName).orElse(null);
        this.lpn = protectGdprFields ? null : pt.getLpn();
        this.userData = Optional.ofNullable(pt.getData()).map(d -> ExportedPaymentMessageDao.mapUserData((String)d, (ObjectMapper)objectMapper)).orElse(null);
    }

    static Map<String, Object> mapUserData(String data, ObjectMapper om) {
        try {
            return (Map)om.readValue(data, USER_DATA_TYPE_REFERENCE);
        }
        catch (Exception e) {
            return Map.of("error", e.getMessage());
        }
    }

    @JsonProperty(value="reason")
    public String getReasonJson() {
        return this.reason != null ? this.reason.name() : null;
    }

    @JsonProperty(value="type")
    public String getTypeJson() {
        return this.type != null ? this.type.name() : null;
    }

    public Long getId() {
        return this.id;
    }

    public Integer getPdmId() {
        return this.pdmId;
    }

    public ExportedMoney getPrice() {
        return this.price;
    }

    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    public LocalDateTime getValidTo() {
        return this.validTo;
    }

    public LocalDateTime getRecieved() {
        return this.recieved;
    }

    public int getTracer() {
        return this.tracer;
    }

    public int getTicketNr() {
        return this.ticketNr;
    }

    public PaymentReason getReason() {
        return this.reason;
    }

    public PaymentType getType() {
        return this.type;
    }

    public String getTariff() {
        return this.tariff;
    }

    public String getLpn() {
        return this.lpn;
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }
}

