/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.repositories.PdmLogCatalogRepository;
import de.rtb.pcon.repositories.PdmLogMessageRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.data_tables.PdmLogRequest;
import de.rtb.pcon.ui.data_tables.export.UserBackgroundJob;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.utils.ExcelOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ExportPdmLogsToExcelTask
extends UserBackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(ExportPdmLogsToExcelTask.class);
    private PdmLogRequest dtRequest;

    public ExportPdmLogsToExcelTask(User user, Locale locale, PdmLogRequest request) {
        super(user, locale);
        this.dtRequest = request;
    }

    public void export() {
        I18nService i18n = (I18nService)this.getApplicationContext().getBean(I18nService.class);
        PdmLogMessageRepository logMsgRepo = (PdmLogMessageRepository)this.getApplicationContext().getBean(PdmLogMessageRepository.class);
        PdmLogCatalogRepository catRepo = (PdmLogCatalogRepository)this.getApplicationContext().getBean(PdmLogCatalogRepository.class);
        PdmRepository pdmRepo = (PdmRepository)this.getApplicationContext().getBean(PdmRepository.class);
        PlatformTransactionManager platformTransactionManager = (PlatformTransactionManager)this.getApplicationContext().getBean(PlatformTransactionManager.class);
        ZoneId userTimeZone = ZoneId.of(this.getRequester().getTimeZoneName());
        this.dtRequest.setUserTimeZone(ZoneId.of(this.getRequester().getTimeZoneName()));
        this.setOutLocation(new File(this.getOutLocation(), this.generateRandomFileName("log", ".xlsx")));
        try (ExcelOutputStream eos = new ExcelOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.getOutLocation())), true);){
            eos.registerDateTimeStyle("dateTimeMin", i18n.getLocalizedMessageWithLocale("excel.format.datetime.short.minutes", this.getLocale(), new Object[0]));
            TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
            transactionTemplate.setReadOnly(true);
            transactionTemplate.executeWithoutResult(transactionStatus -> {
                List pdms = IterableUtils.toList((Iterable)pdmRepo.findAllById((Iterable)this.dtRequest.getPdmIds()));
                pdms.sort(Comparator.comparingInt(Pdm::getNumber));
                List catalogs = CollectionUtils.isEmpty((Collection)this.dtRequest.getCatalogs()) ? IterableUtils.toList((Iterable)catRepo.findAll()) : IterableUtils.toList((Iterable)catRepo.findAllById((Iterable)this.dtRequest.getCatalogs()));
                for (Pdm pdm : pdms) {
                    Sheet sheet = eos.addSheet(pdm.getNumber().toString() + "@" + pdm.getZone().getArea().getId());
                    eos.writeHeaderRow(new String[]{"Date", "Level", "Component", "Message"});
                    sheet.setColumnWidth(0, 6120);
                    sheet.setColumnWidth(2, 3825);
                    try {
                        Stream logStream = logMsgRepo.streamByPdmAndCatalogInAndPdmTimeBetweenOrderByPdmZoneAreaAscPdmAscPdmTimeDesc(pdm, (Collection)catalogs, this.dtRequest.makeOffsetTimeFrom(), this.dtRequest.makeOffsetTimeTo());
                        try {
                            logStream.forEach(lm -> {
                                eos.addRow();
                                eos.writeOffsetlDateTime(lm.getPdmTime(), userTimeZone, "dateTimeMin");
                                eos.writeCell((Number)lm.getLevel());
                                eos.writeCell(lm.getCatalog().getTitle());
                                eos.writeCell(lm.getText());
                                this.getEntityManager().detach(lm);
                            });
                        }
                        finally {
                            if (logStream == null) continue;
                            logStream.close();
                        }
                    }
                    catch (Exception e) {
                        eos.addRow();
                        eos.writeCell("The page is incomplete, because of error: " + e.getMessage());
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("Error by exporting logs to excel.", (Throwable)e);
        }
    }
}

