/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.technical;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.runtime_monitor.PdmRuntimeService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmHwDevice;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.reports.technical.EnergyEntryProjection;
import de.rtb.pcon.ui.controllers.reports.technical.EnergyReportRepository;
import de.rtb.pcon.ui.controllers.reports.technical.ReportAggregation;
import de.rtb.pcon.ui.controllers.reports.technical.ReportTechnicalController;
import de.rtb.pcon.ui.controllers.reports.technical.UiEnergyReport;
import de.rtb.pcon.ui.controllers.reports.technical.UiEnergyReportRow;
import de.rtb.pcon.ui.controllers.reports.technical.UiVoltageReportRow;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.ExcelExportHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Collator;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
@RequestMapping(path={"/api/pcon/ui/report/technical"})
public class ReportTechnicalController {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private I18nService i18n;
    @Autowired
    private PdmFilterRepository pdmFilterRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private PdmRuntimeService pdmRuntimeService;
    @Autowired
    private EnergyReportRepository energyRepo;
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional(readOnly=true)
    @GetMapping(value={"hardware.xlsx"})
    @ResponseBody
    public void hwReportExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        if (pdms.isEmpty()) {
            return;
        }
        Collator collator = this.i18n.getCollator();
        List pdmsHw = this.pdmRepo.findbyIdInPrefetchDevicesAndArea((Collection)pdms.stream().map(Pdm::getId).collect(Collectors.toSet()));
        List<Area> areas = pdmsHw.stream().map(p -> p.getZone().getArea()).distinct().sorted((a1, a2) -> collator.compare(a1.getName(), a2.getName())).toList();
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            for (Area area : areas) {
                XSSFSheet sheet = this.addHardwareSheet(eeh, area);
                pdmsHw.stream().filter(p -> area.equals((Object)p.getZone().getArea())).sorted((p1, p2) -> collator.compare(p1.getName(), p2.getName())).forEach(p -> this.addHardwareRow(eeh, p));
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.technical.hardware.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    private XSSFSheet addHardwareSheet(ExcelExportHelper eeh, Area area) {
        XSSFSheet sheet = eeh.addSheet(area.getName());
        eeh.addHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.pdmNumber", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.pdmName", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cpuType", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cpuFW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.powersupply", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.modemHW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.modemFW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.printerHW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.printerFW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.coinSelectorHW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.coinSelectorDataSet", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.motorReject", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cardreader1HW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cardreader1FW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cardreader2HW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cardreader2FW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.keypadHW", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cpuName", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cpuRam", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cpuRom", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.cpuSerial", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.report.technical.hardware.display", new Object[0])});
        return sheet;
    }

    Optional<JsonNode> devicePropertiesByDeviceName(Stream<PdmHwDevice> deviceStream, String deviceName) {
        return deviceStream.filter(d -> Objects.equals(deviceName, d.getDeviceName())).findAny().map(PdmHwDevice::getProperties).flatMap(arg_0 -> this.parseJsonToNode(arg_0));
    }

    private void addHardwareRow(ExcelExportHelper eeh, Pdm pdm) {
        List ds = pdm.getDevices();
        Optional<PdmHwDevice> dPdm = ds.stream().filter(d -> Objects.equals(DownloadTarget.PDM, d.getTarget())).findAny();
        Optional<PdmHwDevice> dModem = ds.stream().filter(d -> Objects.equals(DownloadTarget.MODEM, d.getTarget())).findAny();
        Optional<PdmHwDevice> dPrinter1 = ds.stream().filter(d -> Objects.equals(DownloadTarget.PRINTER_1, d.getTarget())).findAny();
        Optional<PdmHwDevice> dCoinSelectroHw = ds.stream().filter(d -> Objects.equals(DownloadTarget.COIN_SELECTOR_FW, d.getTarget())).findAny();
        Optional<PdmHwDevice> dCoinSelectroData = ds.stream().filter(d -> Objects.equals(DownloadTarget.COIN_SELECTOR_DATA, d.getTarget())).findAny();
        Optional<PdmHwDevice> dCard1 = ds.stream().filter(d -> Objects.equals(DownloadTarget.CARD_READER_1, d.getTarget())).findAny();
        Optional<PdmHwDevice> dCard2 = ds.stream().filter(d -> Objects.equals(DownloadTarget.CARD_READER_2, d.getTarget())).findAny();
        Optional dCpuProperties = this.devicePropertiesByDeviceName(ds.stream(), "cpu");
        Optional dDisplayProperties = this.devicePropertiesByDeviceName(ds.stream(), "display");
        eeh.addRow();
        eeh.addCell().setCellValue((double)pdm.getNumber().intValue());
        eeh.addCell().setCellValue(pdm.getName());
        eeh.addCell().setCellValue(dPdm.map(PdmHwDevice::getModel).orElse(""));
        eeh.addCell().setCellValue(dPdm.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(this.findDeviceModelByName(ds, "power_supply"));
        eeh.addCell().setCellValue(dModem.map(PdmHwDevice::getModel).orElse(""));
        eeh.addCell().setCellValue(dModem.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(dPrinter1.map(PdmHwDevice::getModel).orElse(""));
        eeh.addCell().setCellValue(dPrinter1.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(dCoinSelectroHw.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(dCoinSelectroData.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(this.findDeviceModelByName(ds, "motor_reject"));
        eeh.addCell().setCellValue(dCard1.map(PdmHwDevice::getModel).orElse(""));
        eeh.addCell().setCellValue(dCard1.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(dCard2.map(PdmHwDevice::getModel).orElse(""));
        eeh.addCell().setCellValue(dCard2.map(PdmHwDevice::getVersion).orElse(""));
        eeh.addCell().setCellValue(this.findDeviceModelByName(ds, "keyboard"));
        eeh.addCell().setCellValue(dCpuProperties.map(n -> n.path("name").textValue()).orElse(""));
        XSSFCell cellRam = eeh.addCell();
        dCpuProperties.map(n -> n.path("ram").intValue()).ifPresentOrElse(arg_0 -> ((XSSFCell)cellRam).setCellValue(arg_0), () -> ((XSSFCell)cellRam).setBlank());
        XSSFCell cellRom = eeh.addCell();
        dCpuProperties.map(n -> n.path("rom").intValue()).ifPresentOrElse(arg_0 -> ((XSSFCell)cellRom).setCellValue(arg_0), () -> ((XSSFCell)cellRam).setBlank());
        eeh.addCell().setCellValue(dCpuProperties.map(n -> n.path("sn").textValue()).orElse(""));
        eeh.addCell().setCellValue(dDisplayProperties.map(n -> n.path("name").textValue()).orElse(""));
    }

    private String findDeviceModelByName(List<PdmHwDevice> ds, String deviceName) {
        return ds.stream().filter(d -> Objects.equals(deviceName, d.getDeviceName())).findAny().map(PdmHwDevice::getModel).orElse("");
    }

    private Optional<JsonNode> parseJsonToNode(String json) {
        try {
            return Optional.of(this.objectMapper.readTree(json));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"voltage.json"})
    @ResponseBody
    public List<UiVoltageReportRow> accuVolatageJson(@RequestParam(value="pdms", required=false) String uiPdmSelector) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        return this.pdmRuntimeService.getLastMonitors((Collection)pdms).stream().filter(mon -> mon.getPowerVoltage() != null).map(row -> new UiVoltageReportRow(row, timeZone)).toList();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"voltage.xlsx"})
    public void accuVolatageExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        List<PdmRuntimeMonitor> pdmVolatges = this.pdmRuntimeService.getLastMonitors((Collection)pdms).stream().filter(mon -> mon.getPowerVoltage() != null).toList();
        boolean showAreas = this.securityService.hasMoreAreas();
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFSheet sheet = eeh.addSheet(this.i18n.getLocalizedMessage("stat.service.batteryVoltage.menu", new Object[0]));
            XSSFCellStyle csDateTime = eeh.createDateTimeStyle(this.i18n.getLocalizedMessage("excel.format.datetime.short.seconds", new Object[0]));
            ArrayList<String> xlsHeares = new ArrayList<String>();
            if (showAreas) {
                xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]));
            }
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.number", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.name", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.voltage", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.datePdm", new Object[0]));
            eeh.addHeaderRow(xlsHeares);
            for (PdmRuntimeMonitor mon2 : pdmVolatges) {
                eeh.addRow();
                if (showAreas) {
                    eeh.addCell().setCellValue(mon2.getPdm().getZone().getArea().getName());
                }
                eeh.addCell().setCellValue((double)mon2.getPdm().getNumber().intValue());
                eeh.addCell().setCellValue(mon2.getPdm().getName());
                eeh.addCell().setCellValue(BigDecimal.valueOf(mon2.getPowerVoltage().floatValue()).setScale(1, RoundingMode.HALF_UP).doubleValue());
                eeh.addCell(csDateTime, DateTimeUtils.toLocalDateTime((OffsetDateTime)mon2.getPowerTime(), (ZoneId)timeZone));
            }
            ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.technical.powerSourceVoltage.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"energy.json"})
    @ResponseBody
    public UiEnergyReport energyJson(@RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = ZonedDateTime.of(uiFrom, userTimeZone).toOffsetDateTime();
        OffsetDateTime to = ZonedDateTime.of(uiTo, userTimeZone).toOffsetDateTime();
        ReportAggregation aggregation = this.calulateReportAggregation(from, to);
        List dbData = this.fetchEnergyReportData((Collection)pdms, from, to, userTimeZone, aggregation);
        List<UiEnergyReportRow> reportTable = dbData.stream().map(UiEnergyReportRow::new).toList();
        return new UiEnergyReport(reportTable, aggregation.toString().toLowerCase());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"energy.xlsx"})
    @ResponseBody
    public void energyExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = ZonedDateTime.of(uiFrom, userTimeZone).toOffsetDateTime();
        OffsetDateTime to = ZonedDateTime.of(uiTo, userTimeZone).toOffsetDateTime();
        ReportAggregation aggregation = this.calulateReportAggregation(from, to);
        List reportData = this.fetchEnergyReportData((Collection)pdms, from, to, userTimeZone, aggregation);
        boolean showAreas = this.securityService.hasMoreAreas();
        ExcelExportHelper eeh = new ExcelExportHelper();
        Function<Float, Double> roundFloat = raw -> BigDecimal.valueOf(raw.floatValue()).setScale(2, RoundingMode.HALF_UP).doubleValue();
        Consumer<Double> writFloatCell = v -> eeh.addCell().setCellValue(v.doubleValue());
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFSheet sheet = eeh.addSheet(this.i18n.getLocalizedMessage("report.technical.energy.export.sheetNameTemplate", new Object[0]));
            XSSFCellStyle csDateTime = eeh.createDateTimeStyle(this.i18n.getLocalizedMessage("excel.format.datetime.short.seconds", new Object[0]));
            ArrayList<String> xlsHeares = new ArrayList<String>();
            if (showAreas) {
                xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]));
            }
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.number", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.name", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.datePdm", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.mcsSolar", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.svenIn", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.svenBat", new Object[0]));
            xlsHeares.add(this.i18n.getLocalizedMessage("comp.table.header.label.voltage", new Object[0]));
            eeh.addHeaderRow(xlsHeares);
            for (EnergyEntryProjection reportRow : reportData) {
                eeh.addRow();
                if (showAreas) {
                    eeh.addCell().setCellValue(reportRow.getPdm().getZone().getArea().getName());
                }
                eeh.addCell().setCellValue((double)reportRow.getPdm().getNumber().intValue());
                eeh.addCell().setCellValue(reportRow.getPdm().getName());
                eeh.addCell(csDateTime, LocalDateTime.of((int)reportRow.getYear(), reportRow.getMonth(), (int)reportRow.getDay(), 0, 0));
                Optional.ofNullable(reportRow.getPowMcsSol()).map(roundFloat).ifPresentOrElse(writFloatCell, () -> ((ExcelExportHelper)eeh).addCell());
                Optional.ofNullable(reportRow.getPowSvenIn()).map(roundFloat).ifPresentOrElse(writFloatCell, () -> ((ExcelExportHelper)eeh).addCell());
                Optional.ofNullable(reportRow.getPowSvenBat()).map(roundFloat).ifPresentOrElse(writFloatCell, () -> ((ExcelExportHelper)eeh).addCell());
                Optional.ofNullable(reportRow.getVolAvg()).map(roundFloat).ifPresentOrElse(writFloatCell, () -> ((ExcelExportHelper)eeh).addCell());
            }
            ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.technical.energy.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    private ReportAggregation calulateReportAggregation(OffsetDateTime from, OffsetDateTime to) {
        Duration reportDuration = Duration.between(from, to);
        if (reportDuration.toDays() < 90L) {
            return ReportAggregation.DAY;
        }
        if (reportDuration.toDays() < 1068L) {
            return ReportAggregation.MONTH;
        }
        return ReportAggregation.YEAR;
    }

    private List<EnergyEntryProjection> fetchEnergyReportData(Collection<Pdm> pdms, OffsetDateTime from, OffsetDateTime to, ZoneId timeZone, ReportAggregation aggregation) {
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + timeZone.toString() + "'").executeUpdate();
        return switch (1.$SwitchMap$de$rtb$pcon$ui$controllers$reports$technical$ReportAggregation[aggregation.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> this.energyRepo.energyReportByDay(pdms, from, to);
            case 2 -> this.energyRepo.energyReportByMonth(pdms, from, to);
            case 3 -> this.energyRepo.energyReportByYear(pdms, from, to);
        };
    }
}

