/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPaymentTypeDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPdmDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueBySummaryDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueMonthlySummaryDto;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;

interface RevenueRepository
extends Repository<PaymentTransaction, PaymentTransactionId> {
    @Query(value="SELECT pdm AS pdm, SUM(pt.amount) AS amount, pt.currency AS currency\nFROM #{#entityName} pt\nJOIN pt.id.pdm pdm\nWHERE pdm in (:pdms)\n  AND pt.id.pdmTime >= :timeFrom\n  AND pt.id.pdmTime < :timeTo\n  AND pt.paymentType in (:paymentTypes)\n  AND pt.paymentReason in (:paymentReasons)\nGROUP BY pdm, pt.currency\nORDER BY pdm DESC")
    public List<RevenueByPdmDto> reportRevenueuByPdm(@Param(value="pdms") Collection<Pdm> var1, @Param(value="timeFrom") OffsetDateTime var2, @Param(value="timeTo") OffsetDateTime var3, @Param(value="paymentTypes") Collection<PaymentType> var4, @Param(value="paymentReasons") Collection<PaymentReason> var5);

    @Query(value="SELECT SUM(pt.amount) AS amount, pt.currency AS currency, pt.paymentType AS paymentType\nFROM #{#entityName} pt\nWHERE pt.id.pdm in (:pdms)\n  AND pt.id.pdmTime >= :from\n  AND pt.id.pdmTime < :to\n  AND pt.paymentReason in (:paymentReasons)\nGROUP BY pt.paymentType, pt.currency\nORDER BY currency, paymentType")
    public List<RevenueByPaymentTypeDto> reportRevenueByPaymentType(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="paymentReasons") Collection<PaymentReason> var4);

    @Query(value="SELECT CAST(pt.id.pdmTime AS date) AS date, pt.paymentType AS paymentType, pt.paymentReason AS paymentReason, COUNT(*) AS nrOfPayments, SUM(pt.amount) AS amount, pt.currency AS currency\nFROM #{#entityName} pt\nWHERE\n  pt.paymentReason in (:paymentReasons)\n  AND pt.id.pdmTime >= :from\n  AND pt.id.pdmTime < :to\n  AND pt.id.pdm in (:pdms)\nGROUP BY\n  CAST(pt.id.pdmTime AS date),\n  pt.paymentType,\n  pt.currency,\n  pt.paymentReason\nORDER BY\n  CAST(pt.id.pdmTime AS date),\n  pt.paymentReason,\n  pt.currency,\n  pt.paymentType")
    public List<RevenueEndOfDayDto> reportRevenueEndOfDay(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="paymentReasons") Collection<PaymentReason> var4);

    @Query(value="SELECT pdm AS pdm, pt.currency AS currency, pt.paymentType AS paymentType, SUM(pt.amount) AS amount, COUNT(*) AS nrOfPayments\nFROM #{#entityName} pt\nJOIN pt.id.pdm pdm\nWHERE\n  pdm in (:pdms)\n  AND pt.id.pdmTime > :from\n  AND pt.id.pdmTime < :to\n  AND pt.paymentReason in (:paymentReasons)\nGROUP BY pt.currency, pt.paymentType, pdm\nORDER BY pdm")
    public List<RevenueBySummaryDto> reportRevenueSummary(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="paymentReasons") Collection<PaymentReason> var4);

    @Query(value="SELECT currency AS currency, YEAR(id.pdmTime) AS year, MONTH(id.pdmTime) AS month, SUM(amount) AS sale\nFROM #{#entityName}\nWHERE id.pdm IN (:pdms)\nAND :user IN ELEMENTS (id.pdm.zone.area.users)\nAND paymentReason IN (:paymentReasons)\nAND id.pdmTime >= :from AND id.pdmTime < :to\nGROUP BY currency, year(id.pdmTime), month(id.pdmTime)\nORDER BY year, month")
    public List<RevenueMonthlySummaryDto> reportMonthlySummary(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="paymentReasons") Collection<PaymentReason> var4, @Param(value="user") User var5);
}

