/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class RevenueByPeriodDto {
    private String periodLabel;
    private int periodOrder;
    private Pdm pdm;
    private PaymentType paymentType;
    private Map<PaymentReason, BigDecimal> values;
    private String currency;

    public RevenueByPeriodDto(int periodOrder) {
        this.periodOrder = periodOrder;
        this.values = new EnumMap(PaymentReason.class);
    }

    public boolean isEmpty() {
        BigDecimal valueSum = this.values.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return BigDecimal.ZERO.compareTo(valueSum) == 0;
    }

    public void setPaymentReasonValue(PaymentReason pr, BigDecimal amount) {
        this.values.put(pr, amount);
    }

    public BigDecimal getPaymentReasonValue(PaymentReason pr) {
        return this.values.computeIfAbsent(pr, k -> BigDecimal.ZERO);
    }

    public BigDecimal getRevenue() {
        return this.values.entrySet().stream().filter(e -> Set.of(PaymentReason.PURCHASE, PaymentReason.PERMIT_EXTENSION).contains(e.getKey())).map(Map.Entry::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getRtpValue() {
        return this.values.entrySet().stream().filter(e -> Set.of(PaymentReason.RTP, PaymentReason.RTP_LOGON, PaymentReason.RTP_LOGOFF, PaymentReason.RTP_FORCED_LOGOFF, PaymentReason.RTP_EXTRINSIC_LOGOFF).contains(e.getKey())).map(Map.Entry::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public String getPeriodLabel() {
        return this.periodLabel;
    }

    public void setPeriodLabel(String periodLabel) {
        this.periodLabel = periodLabel;
    }

    public int getPeriodOrder() {
        return this.periodOrder;
    }

    public void setPeriodOrder(int periodOrder) {
        this.periodOrder = periodOrder;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public void setPdm(Pdm pdm) {
        this.pdm = pdm;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        tsb.append("label", (Object)this.periodLabel);
        tsb.append("order", this.periodOrder);
        tsb.append("type=", (Object)this.paymentType);
        tsb.append("currency", (Object)this.currency);
        this.values.entrySet().stream().forEach(e -> tsb.append(((PaymentReason)e.getKey()).toString(), e.getValue()));
        return tsb.build();
    }
}

