/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.CategoryStrategy;
import de.rtb.pcon.ui.controllers.reports.payments.TableFormatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

class TransactionCollectror<R, C> {
    private CategoryStrategy<R> rowCategoryStrategy;
    private CategoryStrategy<C> colCategoryStrategy;
    private Map<Integer, Map<Integer, Integer>> histogram;

    public TransactionCollectror(CategoryStrategy<R> rowCategoryStrategy, CategoryStrategy<C> colCategoryStrategy) {
        this.rowCategoryStrategy = rowCategoryStrategy;
        this.colCategoryStrategy = colCategoryStrategy;
        this.histogram = new TreeMap();
    }

    public void addData(R rowValue, C colValue) {
        int rowCategory = this.rowCategoryStrategy.category(rowValue);
        int colCategory = this.colCategoryStrategy.category(colValue);
        this.histogram.computeIfAbsent(rowCategory, k -> new TreeMap());
        Map row = (Map)this.histogram.get(rowCategory);
        row.computeIfAbsent(colCategory, k -> 0);
        int quantity = (Integer)row.get(colCategory);
        row.put(colCategory, ++quantity);
    }

    public String[][] histogramTable(TableFormatter<R, C> formatter) {
        TreeSet rowCategories = new TreeSet(this.histogram.keySet());
        if (rowCategories.isEmpty()) {
            return new String[0][];
        }
        TreeSet colCategories = new TreeSet();
        for (Integer rowCategory : rowCategories) {
            Map rowData = (Map)this.histogram.get(rowCategory);
            colCategories.addAll(rowData.keySet());
        }
        String[][] result = new String[rowCategories.size() + 1][colCategories.size() + 1];
        result[0][0] = "";
        int colIndex = 1;
        for (Integer colCategory : colCategories) {
            result[0][colIndex++] = formatter.formatRowHeader(this.colCategoryStrategy.minValue(colCategory.intValue())) + " - " + formatter.formatRowHeader(this.colCategoryStrategy.maxValue(colCategory.intValue()));
        }
        int rowIndex = 1;
        for (Integer rowCategory : rowCategories) {
            result[rowIndex++][0] = formatter.formatColHeader(this.rowCategoryStrategy.minValue(rowCategory.intValue())) + " - " + formatter.formatColHeader(this.rowCategoryStrategy.maxValue(rowCategory.intValue()));
        }
        rowIndex = 1;
        for (Integer rowCategory : rowCategories) {
            colIndex = 1;
            for (Integer colCategory : colCategories) {
                Map row = (Map)this.histogram.get(rowCategory);
                Integer cellValue = row.containsKey(colCategory) ? (Integer)row.get(colCategory) : Integer.valueOf(0);
                result[rowIndex][colIndex] = formatter.formatCellValue(cellValue);
                ++colIndex;
            }
            ++rowIndex;
        }
        return result;
    }
}

