/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.threeten.extra.YearWeek;

class SaleReportRowCategoryYearWeek
extends SaleReportRowCategory {
    private YearWeek delegate;

    public SaleReportRowCategoryYearWeek(int weekBasedYear, int week) {
        this.delegate = YearWeek.of((int)weekBasedYear, (int)week);
    }

    public int compareTo(SaleReportRowCategory o) {
        if (this.getClass().equals(o.getClass())) {
            SaleReportRowCategoryYearWeek other = (SaleReportRowCategoryYearWeek)o;
            return this.delegate.compareTo(other.delegate);
        }
        throw new IllegalStateException("Types " + this.getClass().getName() + " and " + o.getClass().getName() + " are not comparable.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SaleReportRowCategoryYearWeek other = (SaleReportRowCategoryYearWeek)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals((Object)other.delegate));
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String toLocaleString(Locale locale) {
        return this.delegate.getYear() + " - " + this.delegate.getWeek();
    }

    public static Set<SaleReportRowCategory> generateCategoriesBetween(LocalDate from, LocalDate to) {
        TreeSet<SaleReportRowCategory> yearWeeks = new TreeSet<SaleReportRowCategory>();
        LocalDate now = from;
        while (now.isBefore(to) || now.isEqual(to)) {
            int weekBasedYear = now.get(WeekFields.ISO.weekBasedYear());
            int weekNumber = now.get(WeekFields.ISO.weekOfWeekBasedYear());
            yearWeeks.add((SaleReportRowCategory)new SaleReportRowCategoryYearWeek(weekBasedYear, weekNumber));
            now = now.plusDays(1L);
        }
        return yearWeeks;
    }
}

