/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class SaleReport {
    private Table<SaleReportRowCategory, Integer, Integer> saleCounts;
    private Table<SaleReportRowCategory, String, BigDecimal> saleValues;
    private LocalDate reportStart;
    private LocalDate reportEnd;
    private Class<? extends SaleReportRowCategory> timeCategoryClass;

    public SaleReport(Table<SaleReportRowCategory, Integer, Integer> saleCounts, Table<SaleReportRowCategory, String, BigDecimal> saleValues, LocalDate reportStart, LocalDate reportEnd, Class<? extends SaleReportRowCategory> timeCategoryClass) {
        this.saleCounts = saleCounts;
        this.saleValues = saleValues;
        this.reportStart = reportStart;
        this.reportEnd = reportEnd;
        this.timeCategoryClass = timeCategoryClass;
    }

    public SaleReport(Class<? extends SaleReportRowCategory> timeCategoryClass) {
        this.saleCounts = HashBasedTable.create();
        this.saleValues = HashBasedTable.create();
        this.reportStart = LocalDate.MAX;
        this.reportEnd = LocalDate.MIN;
        this.timeCategoryClass = timeCategoryClass;
    }

    public Set<SaleReportRowCategory> getCategories(boolean includeEmpty) {
        TreeSet<SaleReportRowCategory> yearWeeks = new TreeSet<SaleReportRowCategory>();
        if (includeEmpty) {
            try {
                Method m = this.timeCategoryClass.getMethod("generateCategoriesBetween", LocalDate.class, LocalDate.class);
                Object allCategories = m.invoke(null, this.reportStart, this.reportEnd);
                yearWeeks.addAll((Set)allCategories);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot enumerate all categories between " + String.valueOf(this.reportEnd) + " and " + String.valueOf(this.reportEnd) + " for " + this.timeCategoryClass.getName(), e);
            }
        } else {
            yearWeeks.addAll(this.saleCounts.rowKeySet());
            yearWeeks.addAll(this.saleValues.rowKeySet());
        }
        return yearWeeks;
    }

    public Set<Integer> calculateUsedHours(boolean includeEmpty) {
        if (includeEmpty) {
            int lowestHour = this.getLowestHour();
            int highestHour = this.getHighestHour();
            return IntStream.rangeClosed(lowestHour, highestHour).boxed().collect(Collectors.toCollection(TreeSet::new));
        }
        return this.saleCounts.columnKeySet();
    }

    public int getLowestHour() {
        return this.saleCounts.columnKeySet().stream().min(Integer::compare).orElse(0);
    }

    public int getHighestHour() {
        return this.saleCounts.columnKeySet().stream().max(Integer::compare).orElse(0);
    }

    public int getTicketCount(SaleReportRowCategory category, int hour) {
        Integer ticketCount = (Integer)this.saleCounts.get((Object)category, (Object)hour);
        if (ticketCount == null) {
            return 0;
        }
        return ticketCount;
    }

    public int getTicketCount(int hour) {
        return this.saleCounts.column((Object)hour).values().stream().mapToInt(v -> v).sum();
    }

    public int getMaxTicketCount() {
        return this.saleCounts.cellSet().stream().mapToInt(c -> (Integer)c.getValue()).max().orElse(0);
    }

    public Set<String> getCurrencies() {
        return this.saleValues.columnKeySet();
    }

    public BigDecimal getTicketValue(SaleReportRowCategory category, String currency) {
        BigDecimal saleValue = (BigDecimal)this.saleValues.get((Object)category, (Object)currency);
        return saleValue == null ? BigDecimal.ZERO : saleValue;
    }

    public BigDecimal getTicketValue(String currency) {
        return this.saleValues.column((Object)currency).values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

