/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.pdm;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.RemoteAction;
import de.rtb.pcon.model.RemoteActionState;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.controllers.model.UiUser;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.function.Function;

class UiRemoteAction {
    private int id;
    private int code;
    private String parameters;
    private RemoteActionState state;
    private LocalDateTime submitDate;
    private LocalDateTime execDate;
    private UiUser owner;
    @JsonProperty(value="result")
    private UiStatusMessage statusMsg;

    public UiRemoteAction() {
    }

    public UiRemoteAction(RemoteAction ra, ZoneId userTimeZone, Function<Pdm, Optional<OffsetDateTime>> nextKeepAliveFn) {
        this.id = ra.getId();
        this.code = ra.getCode();
        this.parameters = ra.getParmeters();
        this.state = ra.getState();
        this.submitDate = DateTimeUtils.toLocalDateTime((OffsetDateTime)ra.getSubmitDate(), (ZoneId)userTimeZone);
        this.owner = new UiUser(ra.getRequester());
        if (ra.getResult() != null) {
            this.statusMsg = new UiStatusMessage(ra.getResult(), null, userTimeZone);
            this.execDate = DateTimeUtils.toLocalDateTime((OffsetDateTime)ra.getResult().getPdmTime(), (ZoneId)userTimeZone);
        } else {
            this.execDate = nextKeepAliveFn.apply(ra.getPdm()).map(ka -> DateTimeUtils.toLocalDateTime((OffsetDateTime)ka, (ZoneId)userTimeZone)).orElse(null);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public RemoteActionState getState() {
        return this.state;
    }

    @JsonGetter(value="state")
    public int getStateJson() {
        return this.state == null ? null : Integer.valueOf(this.state.ordinal());
    }

    public void setState(RemoteActionState state) {
        this.state = state;
    }

    public LocalDateTime getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(LocalDateTime submitDate) {
        this.submitDate = submitDate;
    }

    public LocalDateTime getExecDate() {
        return this.execDate;
    }

    public void setExecDate(LocalDateTime execDate) {
        this.execDate = execDate;
    }

    public UiUser getOwner() {
        return this.owner;
    }

    public void setOwner(UiUser owner) {
        this.owner = owner;
    }

    public UiStatusMessage getStatusMsg() {
        return this.statusMsg;
    }

    public void setStatusMsg(UiStatusMessage statusMsg) {
        this.statusMsg = statusMsg;
    }
}

