/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.pdm;

import com.fasterxml.jackson.annotation.JsonGetter;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.ui.controllers.model.UiUser;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;

class UiPdmUpdate {
    private final int id;
    private final int planId;
    private final int areaId;
    private final DownloadStatus status;
    private final DownloadTarget target;
    private final DeviceType device;
    private final String planName;
    private final String note;
    private final String version;
    private final String deviceModel;
    private final LocalDateTime downloaded;
    private final LocalDateTime activated;
    private final LocalDateTime planned;
    private final UiUser owner;

    public UiPdmUpdate(DownloadEntry de, ZoneId userTimeZone) {
        DownloadPlan plan = de.getPlan();
        this.id = de.getId();
        this.planId = plan.getId();
        this.areaId = de.getPdm().getZone().getArea().getId();
        this.status = de.getStatus();
        this.target = plan.getDownloadTarget();
        this.device = this.target.deviceType();
        this.deviceModel = plan.getSoftwareDescription().getModel();
        this.planName = plan.getName();
        this.note = plan.getNote();
        this.version = plan.getSoftwareDescription().getVersion();
        this.downloaded = Optional.ofNullable(de.getDownloadConfirmation()).map(t -> t.toZonedDateTime().withZoneSameInstant(userTimeZone).toLocalDateTime()).orElse(null);
        this.activated = Optional.ofNullable(de.getActivationConfirmation()).map(t -> t.toZonedDateTime().withZoneSameInstant(userTimeZone).toLocalDateTime()).orElse(null);
        this.planned = Optional.ofNullable(plan.getModifiedAt()).map(t -> t.toZonedDateTime().withZoneSameInstant(userTimeZone).toLocalDateTime()).orElse(null);
        this.owner = Optional.ofNullable(de.getPlan().getModifiedBy()).map(UiUser::new).orElse(null);
    }

    @JsonGetter(value="target")
    public Integer getTargetJson() {
        return this.target == null ? null : Integer.valueOf(this.target.ordinal());
    }

    @JsonGetter(value="status")
    public Integer getStatusJson() {
        return this.status == null ? null : Integer.valueOf(this.status.ordinal());
    }

    @JsonGetter(value="device")
    public Integer getDeviceJson() {
        return this.device == null ? null : Integer.valueOf(this.device.ordinal());
    }

    public int getId() {
        return this.id;
    }

    public int getPlanId() {
        return this.planId;
    }

    public int getAreaId() {
        return this.areaId;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public DownloadTarget getTarget() {
        return this.target;
    }

    public DeviceType getDevice() {
        return this.device;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getNote() {
        return this.note;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public LocalDateTime getDownloaded() {
        return this.downloaded;
    }

    public LocalDateTime getActivated() {
        return this.activated;
    }

    public LocalDateTime getPlanned() {
        return this.planned;
    }

    public UiUser getOwner() {
        return this.owner;
    }
}

