/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.logbooks;

import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId_;
import de.rtb.pcon.model.PaymentTransaction_;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.Pdm_;
import de.rtb.pcon.model.TariffInfo_;
import de.rtb.pcon.model.zone.Zone_;
import de.rtb.pcon.ui.controllers.logbooks.LogbookPaymentRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookRepositotyUtils;
import de.rtb.pcon.ui.controllers.logbooks.SimpleSlice;
import de.rtb.pcon.ui.data_tables.DataTableColumn;
import de.rtb.pcon.ui.data_tables.DataTableOrder;
import de.rtb.pcon.ui.data_tables.LogbookDataTableRequest;
import de.rtb.pcon.ui.data_tables.PaymentRequest;
import de.rtb.pcontrol.ui.controller.UiConvertHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class LogbookPaymentRepository {
    @Autowired
    private EntityManager entityManager;

    @Transactional(readOnly=true)
    public SimpleSlice<PaymentTransaction> findPayments(Collection<Pdm> pdms, PaymentRequest filter) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(PaymentTransaction.class);
        Root root = criteriaQuery.from(PaymentTransaction.class);
        PaymentLogbookJoins joins = this.makeJoins(root);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, pdms, filter);
        List order = this.makeOrder(criteriaBuilder, root, joins, (LogbookDataTableRequest)filter);
        criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(order);
        TypedQuery query = this.entityManager.createQuery(criteriaQuery);
        query.setFirstResult(filter.getStart());
        query.setMaxResults(filter.getLength() + 1);
        List result = query.getResultList();
        return new SimpleSlice(result, filter.getLength());
    }

    public Long countPayments(Collection<Pdm> pdms, PaymentRequest filter) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root root = countQuery.from(PaymentTransaction.class);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, pdms, filter);
        countQuery.select((Selection)criteriaBuilder.count((Expression)root)).where((Expression)predicate);
        return (Long)this.entityManager.createQuery(countQuery).getSingleResult();
    }

    @Transactional(readOnly=true)
    public Stream<PaymentTransaction> streamPayments(Collection<Pdm> pdms, PaymentRequest filter) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(PaymentTransaction.class);
        Root root = criteriaQuery.from(PaymentTransaction.class);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, pdms, filter);
        Order order = criteriaBuilder.desc((Expression)root.get(PaymentTransaction_.id).get(PaymentTransactionId_.pdmTime));
        criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(new Order[]{order});
        return this.entityManager.createQuery(criteriaQuery).setHint("org.hibernate.fetchSize", (Object)"10000").getResultStream();
    }

    private PaymentLogbookJoins makeJoins(Root<PaymentTransaction> root) {
        Join idJoin = root.join(PaymentTransaction_.id);
        Join pdmJoin = idJoin.join(PaymentTransactionId_.pdm, JoinType.INNER);
        Join zoneJoin = pdmJoin.join(Pdm_.zone, JoinType.INNER);
        Join areaJoin = zoneJoin.join(Zone_.area, JoinType.INNER);
        Join tariffJoin = root.join(PaymentTransaction_.tariffInfo, JoinType.LEFT);
        return new PaymentLogbookJoins(idJoin, zoneJoin, areaJoin, tariffJoin);
    }

    private Predicate makePredicate(CriteriaBuilder criteriaBuilder, Root<PaymentTransaction> root, Collection<Pdm> pdms, PaymentRequest filter) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        Path id = root.get(PaymentTransaction_.id);
        predicateList.add(id.get(PaymentTransactionId_.pdm).in(pdms));
        predicateList.add(criteriaBuilder.greaterThanOrEqualTo((Expression)id.get(PaymentTransactionId_.pdmTime), (Comparable)filter.makeOffsetTimeFrom()));
        predicateList.add(criteriaBuilder.lessThan((Expression)id.get(PaymentTransactionId_.pdmTime), (Comparable)filter.makeOffsetTimeTo()));
        if (CollectionUtils.isNotEmpty((Collection)filter.getPaymentReasons())) {
            List reasons = UiConvertHelper.convertPaymentReasons((Collection)filter.getPaymentReasons());
            predicateList.add(root.get(PaymentTransaction_.paymentReason).in((Collection)reasons));
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getPaymentTypes())) {
            List types = UiConvertHelper.convertPaymentTypes((Collection)filter.getPaymentTypes());
            predicateList.add(root.get(PaymentTransaction_.paymentType).in((Collection)types));
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getTariffs())) {
            boolean hasNullTariff = filter.getTariffs().contains(null);
            LinkedList<Predicate> tariffPredicateList = new LinkedList<Predicate>();
            if (hasNullTariff) {
                tariffPredicateList.add(criteriaBuilder.isNull((Expression)root.get(PaymentTransaction_.tariffInfo)));
            }
            if (CollectionUtils.isNotEmpty((Collection)filter.getTariffs())) {
                tariffPredicateList.add(root.get(PaymentTransaction_.tariffInfo).get(TariffInfo_.id).in((Collection)filter.getTariffs()));
            }
            if (!tariffPredicateList.isEmpty()) {
                predicateList.add(criteriaBuilder.or(tariffPredicateList.toArray(new Predicate[0])));
            }
        }
        filter.getColumns().stream().filter(dtc -> StringUtils.equals((CharSequence)"paymentCode", (CharSequence)dtc.getName())).findAny().flatMap(c -> Optional.ofNullable(c.getSearch())).ifPresent(search -> {
            String cardNumberText = search.getValue();
            if (!StringUtils.isEmpty((CharSequence)cardNumberText)) {
                predicateList.add(criteriaBuilder.like((Expression)root.get(PaymentTransaction_.paymentCode), "%" + cardNumberText.toUpperCase() + "%"));
            }
        });
        filter.getColumns().stream().filter(dtc -> StringUtils.equals((CharSequence)"lpn", (CharSequence)dtc.getName())).findAny().flatMap(c -> Optional.ofNullable(c.getSearch())).ifPresent(search -> {
            String licensePlateText = search.getValue();
            if (!StringUtils.isEmpty((CharSequence)licensePlateText)) {
                licensePlateText = MessageParserHelper.parseLcn((String)licensePlateText);
                predicateList.add(criteriaBuilder.like((Expression)root.get(PaymentTransaction_.lpn), "%" + licensePlateText + "%"));
            }
        });
        filter.getColumns().stream().filter(dtc -> StringUtils.equals((CharSequence)"psn", (CharSequence)dtc.getName())).findAny().flatMap(c -> Optional.ofNullable(c.getSearch())).ifPresent(search -> {
            String parkingSpeceNumber = search.getValue();
            if (StringUtils.isNumeric((CharSequence)parkingSpeceNumber)) {
                predicateList.add(criteriaBuilder.equal((Expression)root.get(PaymentTransaction_.psn), (Object)Integer.parseInt(parkingSpeceNumber)));
            }
        });
        return criteriaBuilder.and(predicateList.toArray(new Predicate[0]));
    }

    private List<Order> makeOrder(CriteriaBuilder cb, Root<?> root, PaymentLogbookJoins joins, LogbookDataTableRequest filter) {
        LinkedList<Order> orders = new LinkedList<Order>();
        for (DataTableOrder dtOrderRule : filter.getOrder()) {
            Path path;
            String fullProperty = ((DataTableColumn)filter.getColumns().get(dtOrderRule.getColumn())).getName();
            String[] propertyParts = StringUtils.split((String)fullProperty, (String)".");
            if (propertyParts.length == 1) {
                path = root.get(propertyParts[0]);
            } else {
                String mainProp = propertyParts[0];
                String subProp = propertyParts[1];
                path = switch (mainProp) {
                    case "id" -> joins.id().get(subProp);
                    case "area" -> joins.area().get(subProp);
                    case "tariff" -> joins.tariff().get(subProp);
                    case "zone" -> joins.zone().get(subProp);
                    default -> throw new IllegalArgumentException("Property : " + mainProp + " is not supported for PaymentTransaction.");
                };
            }
            String direction = dtOrderRule.getDirection();
            orders.add(LogbookRepositotyUtils.createOrderFromString((CriteriaBuilder)cb, (Path)path, (String)direction));
        }
        return orders;
    }
}

