/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.dashboard;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.dashboard.PaymentCountByHourDto;
import de.rtb.pcon.ui.controllers.dashboard.RevenueByDayDto;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.ListPagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

interface DashboardRepository
extends ListPagingAndSortingRepository<PaymentTransaction, PaymentTransactionId> {
    @Query(value="SELECT\n  year(pt.id.pdmTime) AS year,\n  month(pt.id.pdmTime) AS month,\n  day(pt.id.pdmTime) AS day,\n  pt.currency AS currency,\n  sum(pt.amount) AS revenue\nFROM #{#entityName} pt\nWHERE\n  pt.id.pdmTime >= :from AND pt.id.pdmTime < :to\nAND\n  pt.id.pdm in (:pdms)\nAND\n  paymentReason in (:paymentReasons)\nGROUP BY year, month, day, currency\nORDER BY year, month, day, currency")
    public List<RevenueByDayDto> fetchRevenueForPdmsByDay(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="paymentReasons") List<PaymentReason> var4);

    @Query(value="SELECT new de.rtb.pcon.ui.controllers.dashboard.PaymentCountByHourDto (\n  EXTRACT(HOUR FROM pt.id.pdmTime) AS hour, COUNT(*) AS count, pt.currency AS currency\n)\nFROM #{#entityName} pt\nWHERE\npt.id.pdmTime > :from\nAND pt.paymentReason in (:paymentReasons)\nAND pt.id.pdm.zone.area in (:areas)\nGROUP BY hour, pt.currency\nORDER BY hour, pt.currency")
    public List<PaymentCountByHourDto> fetchSaleCountsByHour(@Param(value="areas") Collection<Area> var1, @Param(value="from") OffsetDateTime var2, @Param(value="paymentReasons") List<PaymentReason> var3);

    @Query(value="SELECT pdm\nFROM #{#entityName} pt\nJOIN pt.id.pdm as pdm\nWHERE pdm.zone.area in (:areas)\nAND pt.id.pdmTime > :from AND pt.id.pdmTime < :to\nAND pt.paymentReason in (:paymentReasons)\nGROUP BY pdm\nORDER BY SUM(pt.amount) DESC")
    public Slice<Pdm> findTopSellingPdm(@Param(value="areas") Collection<Area> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="paymentReasons") Collection<PaymentReason> var4, Pageable var5);
}

