/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.touchnet;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.touchnet.OneCardApiService;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigDto;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigService;
import de.rtb.pcon.features.partners.touchnet.OneCardException;
import de.rtb.pcon.features.partners.touchnet.OneCardPreInitResponse;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
class OneCardRtrPreInit
implements RealTimeRequest {
    @Autowired
    @Qualifier(value="rt3rdPartyApi")
    private RestTemplate restTemplate;
    @Autowired
    private BlockingCallGuard blokcingCallGuard;
    @Autowired
    private OneCardConfigService configService;
    @Autowired
    private OneCardApiService apiService;

    OneCardRtrPreInit() {
    }

    public int getId() {
        return 45;
    }

    public String getDescription() {
        return "OneCard, pre-init";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        String sessionId = ctx.getLocalString("sessionId");
        Pdm pdm = ctx.findPdmEntity();
        try {
            OneCardPreInitResponse apiResponse = this.apiService.transPreInit(pdm, sessionId);
            return Map.of("oneCardTransId", apiResponse.getOneCardTransId());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
        catch (OneCardException e) {
            return e.toPdmMnemonicMap();
        }
    }
}

