/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.features.partners.PartnesConfigurationServiceBase;
import de.rtb.pcon.features.partners.brain_behind.BrbRequestConfigDto;
import de.rtb.pcon.features.partners.brain_behind.crypto.BrbCryptoService;
import de.rtb.pcon.features.partners.brain_behind.crypto.BrbCryptoServiceAESImpl;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.repositories.AreaPartnerRepository;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.springframework.stereotype.Service;

@Service
class BrbConfigurationService
extends PartnesConfigurationServiceBase<BrbRequestConfigDto> {
    public static final String URL_BASE = "https://loy.brain-behind.com/CU_WebApi.asmx/";
    public static final String URL_BASE_DEV = "https://webapi-dev.brain-behind.com/CU_WebAPI.asmx/";
    public static final String URL_BALANCE = "https://loy.brain-behind.com/CU_WebApi.asmx/CU_Check_Balance_Array";
    public static final String URL_PAY = "https://loy.brain-behind.com/CU_WebApi.asmx/CU_Consume_Voucher_Terminalgroup";
    public static final String URL_QR_CODE = "https://loy.brain-behind.com/CU_WebApi.asmx/CU_Service";

    public BrbConfigurationService(AreaPartnerRepository configRepo, ObjectMapper objectMapper) {
        super(AreaPartnerType.BRAIN_BEHIND, configRepo, objectMapper);
    }

    public BrbRequestConfigDto newDefautlConfig() {
        return new BrbRequestConfigDto();
    }

    public BrbCryptoService cryptoService(String password, String salt) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException {
        return new BrbCryptoServiceAESImpl(password, salt);
    }

    public static String makeTerminalId(Pdm pdm) {
        return pdm.getNumber() + "@" + pdm.getZone().getArea().getId();
    }
}

