/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.integration.PdmMessageProcessionException;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.gates.PresentTicketEntity;
import de.rtb.pcon.features.bonus.gates.PresentTicketPdmDto;
import de.rtb.pcon.features.bonus.gates.PresentTicketRepository;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class BonGateRtrAdd
implements RealTimeRequest {
    @Autowired
    private PresentTicketRepository repo;
    @Autowired
    private ObjectMapper om;

    BonGateRtrAdd() {
    }

    public int getId() {
        return 33;
    }

    public String getDescription() {
        return "Gate, add ticket";
    }

    @Transactional
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        if (zone == null) {
            throw new PdmMessageProcessionException("PDM must be in zone.");
        }
        try {
            PresentTicketPdmDto dto = (PresentTicketPdmDto)ctx.getLocalObject("tic", PresentTicketPdmDto.class);
            PresentTicketEntity tic = new PresentTicketEntity();
            ZoneId timeZone = ctx.global().getTimeZone();
            tic.setTicketNumber(dto.ticketNumber());
            tic.setZone(zone);
            tic.setArrival(DateTimeUtils.toOffsetDateTime((LocalDateTime)dto.arrival(), (ZoneId)timeZone));
            tic.setValidFrom(DateTimeUtils.toOffsetDateTime((LocalDateTime)dto.validFrom(), (ZoneId)timeZone));
            tic.setValidTo(DateTimeUtils.toOffsetDateTime((LocalDateTime)dto.validTo(), (ZoneId)timeZone));
            tic.setType(dto.ticketType());
            String dataJson = dto.data() != null ? this.om.writeValueAsString((Object)dto.data()) : null;
            tic.setData(dataJson);
            List allowedFlags = Optional.ofNullable(dto.flagsAllowed()).orElse(List.of());
            List enabledFlags = Optional.ofNullable(dto.flagsEnabled()).orElse(List.of());
            List<String> enabledFlagsFiltered = enabledFlags.stream().filter(allowedFlags::contains).toList();
            tic.setFlagsAllowed(allowedFlags);
            tic.setFlagsEnabled(enabledFlagsFiltered);
            this.repo.save((Object)tic);
            return Map.of();
        }
        catch (DataIntegrityViolationException e) {
            throw new PdmMessageProcessionException("Cannot add ticket to the database.", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new PdmMessageProcessionException((Throwable)e);
        }
    }
}

