/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.runtime_monitor;

import de.rtb.pcon.core.pdm.msg.json.device_report.DeviceReport;
import de.rtb.pcon.core.pdm.msg.json.device_report.Power;
import de.rtb.pcon.core.pdm.msg.json.device_report.PowerCouner;
import de.rtb.pcon.core.runtime_monitor.AliveMonitorService;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.AccuLevel;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import de.rtb.pcon.repositories.AccuLevelRepository;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PowerMonitorService {
    private static final Logger log = LoggerFactory.getLogger(PowerMonitorService.class);
    private static final float ACCU_VOLTAGE_STORE_DELTA = 0.5f;
    @Autowired
    private AccuLevelRepository accuLevelRepo;
    @Autowired
    private AliveMonitorService aliveMonitorService;

    @Transactional
    public void processPowerReprot(PdmMessageDto m, PdmRuntimeMonitor pdmRtm) {
        Optional accuLevel = m.getRdh() != null ? this.parseAccuLevelV2(m) : (m.getAcu() != null ? this.parseAccuLevelV1(m, pdmRtm) : Optional.empty());
        accuLevel.ifPresent(al -> {
            this.accuLevelRepo.save(al);
            this.aliveMonitorService.updateAccuLevel(pdmRtm, al);
        });
    }

    Optional<AccuLevel> parseAccuLevelV2(PdmMessageDto m) {
        DeviceReport deviceReport = m.getRdh();
        if (deviceReport == null || deviceReport.getPower() == null || deviceReport.getPower().getBattery() == null) {
            return Optional.empty();
        }
        log.debug("~ Power report");
        Power power = deviceReport.getPower();
        AccuLevel accuLevel = new AccuLevel();
        accuLevel.setPdm(m.getPdm());
        accuLevel.setPdmTime(DateTimeUtils.toOffsetDateTime((LocalDateTime)deviceReport.getPeriod(), (ZoneId)m.getTimeZone()));
        Optional.ofNullable(power.getBattery()).flatMap(b -> Optional.ofNullable(b.getVoltage())).ifPresent(v -> {
            accuLevel.setVoltageAvg(PowerMonitorService.zeroToNull((Float)((Float)v.getAvg())));
            accuLevel.setVoltageMin(PowerMonitorService.zeroToNull((Float)((Float)v.getMin())));
        });
        Function<Integer, Float> mAh2Ah = v -> Float.valueOf((float)((double)v.intValue() / 1000.0));
        Optional<PowerCouner> powerCounter = Optional.ofNullable(power.getPowerCounter());
        powerCounter.flatMap(pow -> Optional.ofNullable(pow.getSol())).map(mAh2Ah).ifPresent(arg_0 -> ((AccuLevel)accuLevel).setPowSvenIn(arg_0));
        powerCounter.flatMap(pow -> Optional.ofNullable(pow.getBat())).map(mAh2Ah).ifPresent(arg_0 -> ((AccuLevel)accuLevel).setPowSvenBat(arg_0));
        Optional.ofNullable(power.getSolar()).flatMap(sol -> Optional.ofNullable(sol.getIncome())).map(mAh2Ah).ifPresent(arg_0 -> ((AccuLevel)accuLevel).setPowMcsSol(arg_0));
        return Optional.of(accuLevel);
    }

    Optional<AccuLevel> parseAccuLevelV1(PdmMessageDto m, PdmRuntimeMonitor pdmRtm) {
        Float voltage = m.getAcu();
        if ((double)voltage.floatValue() > 20.0 || (double)voltage.floatValue() < 5.0) {
            return Optional.empty();
        }
        log.debug("~ Power report, PDM5");
        if (pdmRtm.getPowerTime() == null || pdmRtm.getPowerVoltage() == null || Math.abs(pdmRtm.getPowerVoltage().floatValue() - voltage.floatValue()) >= 0.5f || Duration.between(pdmRtm.getPowerTime(), m.getDatTim()).toHours() >= 24L) {
            AccuLevel accuLevel = new AccuLevel();
            accuLevel.setPdm(m.getPdm());
            accuLevel.setPdmTime(m.getDatTim());
            accuLevel.setVoltageAvg(voltage);
            return Optional.of(accuLevel);
        }
        return Optional.empty();
    }

    static Float zeroToNull(Float val) {
        if (val != null && val.floatValue() == 0.0f) {
            return null;
        }
        return val;
    }
}

