/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.file;

import de.rtb.pcon.core.fw_download.ui.file.FirmwareDownloadSpecifications;
import de.rtb.pcon.core.fw_download.ui.file.UiDeviceTypeWithCount;
import de.rtb.pcon.core.fw_download.ui.file.UiSoftwareDerscriptionEditable;
import de.rtb.pcon.core.fw_download.ui.file.UiSoftwareDescription;
import de.rtb.pcon.core.services.pdm_in.SoftwareDataProvider;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.model.download.SoftwareDescription;
import de.rtb.pcon.repositories.PdmHwDevicesRepository;
import de.rtb.pcon.repositories.fw_update.SoftwareDescriptionRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/fw-update/files"})
@PreAuthorize(value="hasRole('ROLE_PCON_SOFTWARE_MANAGE')")
class FirmwareUpdateFileController {
    private static final Logger log = LoggerFactory.getLogger(FirmwareUpdateFileController.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private SoftwareDescriptionRepository softwareDescriptionRepo;
    @Autowired
    private I18nService i18n;
    @Autowired
    private SoftwareDataProvider swDataProvider;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private PdmHwDevicesRepository hwDeviceRepo;

    FirmwareUpdateFileController() {
    }

    @GetMapping
    @Transactional(readOnly=true)
    public ResponseEntity<List<UiSoftwareDescription>> getFiles(@RequestParam(name="area", required=false) Integer areaId, @RequestParam(name="deviceType", required=false) Integer deviceType, @RequestParam(name="search", required=false) String search, @RequestParam(name="hidden", defaultValue="false") boolean hidden, @RequestParam(name="page", defaultValue="1") int pageNr, @RequestParam(name="size", defaultValue="10") int pageSize) {
        PageRequest pageable = PageRequest.of((int)(pageNr - 1), (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timeCreated"});
        Specification spec = FirmwareDownloadSpecifications.isAreaNull();
        if (areaId != null) {
            Area area = this.entityLoader.loadArea(areaId.intValue());
            spec = spec.or(FirmwareDownloadSpecifications.hasArea((Area)area));
        }
        spec = hidden ? spec.and(FirmwareDownloadSpecifications.isHidden()) : spec.and(FirmwareDownloadSpecifications.isVisible());
        if (deviceType != null) {
            spec = spec.and(FirmwareDownloadSpecifications.isDeviceType((DeviceType)DeviceType.fromOrdinal((int)deviceType)));
        }
        if (StringUtils.isNotBlank((CharSequence)search)) {
            spec = spec.and(FirmwareDownloadSpecifications.containsText((String)search));
        }
        Page dataPage = this.softwareDescriptionRepo.findAll(spec, (Pageable)pageable);
        Set swInUse = this.softwareDescriptionRepo.findSoftwareInUse((Collection)dataPage.getContent());
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        List<UiSoftwareDescription> uiData = dataPage.stream().map(el -> new UiSoftwareDescription(el, userTimeZone, swInUse.contains(el))).toList();
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).header("page-total", new String[]{Integer.toString(dataPage.getTotalPages())})).header("page-current", new String[]{Integer.toString(pageNr)})).header("page-size", new String[]{Integer.toString(pageSize)})).body(uiData);
    }

    @PostMapping
    @PreAuthorize(value="hasRole('ROLE_PCON_SOFTWARE_MANAGE')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @Transactional
    public ResponseEntity<Map<String, Object>> uploadNewFile(@RequestParam(name="file") MultipartFile uiFile, @RequestParam(name="area", required=false) Integer uiAreaId, @RequestParam(name="device") int uiDeviceType, @RequestParam(name="model") String uiDeviceModel, @RequestParam(name="version", required=false) String uiVersion, @RequestParam(name="name") String uiName, @RequestParam(name="description") String uiDescription) throws IOException {
        DeviceType deviceType = DeviceType.fromOrdinal((int)uiDeviceType);
        Object area = uiAreaId == null && this.securityService.hasRole(UserRole.ROLE_ADMIN_SOFTWARE) ? null : this.entityLoader.loadArea(uiAreaId.intValue());
        if (uiFile.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.EXPECTATION_FAILED).body(Map.of("error", "File is empty"));
        }
        SoftwareDescription swd = new SoftwareDescription();
        swd.setName(uiName);
        swd.setNote(uiDescription);
        swd.setDeviceType(deviceType);
        swd.setFileName(uiFile.getOriginalFilename());
        swd.setModel(uiDeviceModel);
        swd.setArea(area);
        swd.setVersion(uiVersion);
        swd.setTimeCreated(DateTimeUtils.serverNowO());
        swd.setVisible(true);
        swd.setAuthor(this.securityService.getCurrentUser());
        this.softwareDescriptionRepo.save((Object)swd);
        if (DeviceType.PDM_FW.equals((Object)deviceType) && StringUtils.startsWith((CharSequence)uiDeviceModel, (CharSequence)"PDM5")) {
            String versionInfo = this.swDataProvider.addPdm5FwSoftwareItems(swd, uiFile.getInputStream());
            if (versionInfo == null) {
                this.softwareDescriptionRepo.delete((Object)swd);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.EXPECTATION_FAILED).body(Map.of("error", "This is not valid PDM5 firmware file."));
            }
            swd.setModel("PDM5_" + versionInfo.substring(0, 2));
            swd.setVersion(versionInfo.substring(2));
        } else if (DeviceType.PDM_CONFIG.equals((Object)deviceType) && uiFile.getOriginalFilename().toLowerCase().endsWith(".pdms")) {
            this.swDataProvider.addConfigBundle(swd, uiFile.getInputStream());
        } else {
            this.swDataProvider.addData(swd, uiFile.getBytes());
        }
        log.debug("File '{}' ({} kB) uploaded.", (Object)uiFile.getOriginalFilename(), (Object)(uiFile.getSize() / 1024L));
        if (actionLogger.isInfoEnabled()) {
            this.securityService.getCurrentUser();
            actionLogger.info("User {} has uploaded file {} into area {}", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), uiFile.getOriginalFilename(), swd.getArea()});
        }
        return ResponseEntity.ok(Map.of("id", swd.getId()));
    }

    @GetMapping(value={"{id}"})
    @Transactional(readOnly=true)
    public UiSoftwareDescription getFileInfo(@PathVariable(value="id") int id) {
        SoftwareDescription swd = this.loadSwDescription(id);
        Set swInUse = this.softwareDescriptionRepo.findSoftwareInUse(List.of(swd));
        return new UiSoftwareDescription(swd, this.i18n.userTimeZoneId(), swInUse.contains(swd));
    }

    @DeleteMapping(value={"{id}"})
    @Transactional
    public void deleteFileInfo(@PathVariable(value="id") int id, HttpServletResponse response) {
        SoftwareDescription swd = this.loadSwDescription(id);
        boolean swInUse = this.softwareDescriptionRepo.findSoftwareInUse(List.of(swd)).contains(swd);
        if (!swInUse) {
            this.softwareDescriptionRepo.delete((Object)swd);
            this.swDataProvider.removeOrphansSoftwareItems();
            response.setStatus(HttpStatus.OK.value());
        } else {
            log.error("Cannot delete SoftwareDescription #{} because it is used in download plan(s).", (Object)swd.getId());
            response.setStatus(HttpStatus.LOCKED.value());
        }
    }

    @PutMapping(value={"{id}"})
    @Transactional
    public UiSoftwareDerscriptionEditable putFileInfo(@PathVariable(value="id") int id, @RequestBody UiSoftwareDerscriptionEditable uiData, Authentication principal) {
        boolean isSwAdmin = principal.getAuthorities().contains(UserRole.toGrantedAuthority((UserRole)UserRole.ROLE_ADMIN_SOFTWARE));
        return this.patchFileInfoResource(id, uiData, false, isSwAdmin);
    }

    @PatchMapping(value={"{id}"})
    @Transactional
    public UiSoftwareDerscriptionEditable patchFileInfo(@PathVariable(value="id") int id, @RequestBody UiSoftwareDerscriptionEditable uiData, Authentication principal) {
        boolean isSwAdmin = principal.getAuthorities().contains(UserRole.toGrantedAuthority((UserRole)UserRole.ROLE_ADMIN_SOFTWARE));
        return this.patchFileInfoResource(id, uiData, true, isSwAdmin);
    }

    private UiSoftwareDerscriptionEditable patchFileInfoResource(int id, UiSoftwareDerscriptionEditable props, boolean patch, boolean isSwAdmin) {
        String diff;
        SoftwareDescription swd = this.loadSwDescription(id);
        if (swd.getArea() == null && !isSwAdmin) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        UiSoftwareDerscriptionEditable diffBase = new UiSoftwareDerscriptionEditable(swd);
        if (!patch || props.getName() != null) {
            swd.setName(props.getName());
        }
        if (props.getVersion() != null) {
            swd.setVersion(props.getVersion());
        }
        if (props.getDescription() != null) {
            swd.setNote(props.getDescription());
        }
        if (props.getVisible() != null) {
            swd.setVisible(props.getVisible().booleanValue());
        }
        if (actionLogger.isInfoEnabled() && StringUtils.isNotBlank((CharSequence)(diff = LoggerUtils.makeObjectDiff((Object)new UiSoftwareDerscriptionEditable(swd), (Object)diffBase)))) {
            this.securityService.getCurrentUser();
            actionLogger.info("User {} has changed properties of Software description #{} {}", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), swd.getId(), diff});
        }
        return new UiSoftwareDerscriptionEditable(swd);
    }

    @GetMapping(value={"types"})
    @Transactional(readOnly=true)
    public List<UiDeviceTypeWithCount> getDeviceTypesFromSoftware(@RequestParam(name="area", required=false) Integer uiArea) {
        Area area = Optional.ofNullable(uiArea).map(arg_0 -> ((SecureEntityLoaderService)this.entityLoader).loadArea(arg_0)).orElse(null);
        return this.softwareDescriptionRepo.findDeviceTypesWithCount(area).stream().map(UiDeviceTypeWithCount::new).toList();
    }

    @GetMapping(value={"pdmHwTree"})
    @Transactional(readOnly=true)
    public Map<Integer, Set<String>> getDevicesFromPdms(@RequestParam(name="area", required=false) Integer uiArea) {
        HashMap<Integer, Set<String>> result = new HashMap<Integer, Set<String>>();
        Optional.ofNullable(uiArea).map(arg_0 -> ((SecureEntityLoaderService)this.entityLoader).loadArea(arg_0)).map(arg_0 -> ((PdmHwDevicesRepository)this.hwDeviceRepo).findDeviceGroups(arg_0)).orElseGet(() -> ((PdmHwDevicesRepository)this.hwDeviceRepo).findDeviceGroupsGlobal()).forEach(t -> {
            DownloadTarget downloadTraget = (DownloadTarget)t.get("target", DownloadTarget.class);
            if (downloadTraget.deviceType() != null) {
                String model = (String)t.get("model", String.class);
                Set models = result.computeIfAbsent(downloadTraget.deviceType().ordinal(), k -> new HashSet());
                models.add(model);
            }
        });
        return result;
    }

    private SoftwareDescription loadSwDescription(int id) {
        SoftwareDescription swd = (SoftwareDescription)this.softwareDescriptionRepo.findById((Object)id).orElseThrow(() -> new EntityNotAvailableException(HttpStatus.NOT_FOUND));
        if (swd.getArea() == null) {
            return swd;
        }
        this.entityLoader.checkAreaAccessForCurrentUser(swd.getArea());
        return swd;
    }
}

