/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.config.general;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.core.services.pdm_in.ScalableResourcesConfigurationService;
import de.rtb.pcon.features.partners.PartnerTransportTask;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ExecutorsConfig {
    private static final Logger log = LoggerFactory.getLogger(ExecutorsConfig.class);
    public static final String EXECUTOR_BACKGROUND = "taskExecutorBackground";
    public static final String EXECUTOR_PAYMENT_REGISTRATION = "taskExecutorPaymentRegistration";

    @Bean(value={"taskExecutorBackground"})
    Executor backroundTaskExecutor(DevelopmentProperties devProps) {
        if (devProps.isVirtualThreads()) {
            return new VirtualThreadTaskExecutor("bg-task-");
        }
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(1);
        taskExecutor.setMaxPoolSize(5);
        taskExecutor.setKeepAliveSeconds(120);
        taskExecutor.setAllowCoreThreadTimeOut(true);
        taskExecutor.setQueueCapacity(100);
        taskExecutor.setThreadNamePrefix("bg-task-");
        taskExecutor.setThreadPriority(1);
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(value={"taskExecutorPaymentRegistration"})
    Executor paymentForeignRetisterService(ScalableResourcesConfigurationService resCfg, DevelopmentProperties devProps) {
        if (devProps.isVirtualThreads()) {
            return new VirtualThreadTaskExecutor("pt-");
        }
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(resCfg.tpForeignRegisterThreads);
        executor.setMaxPoolSize(resCfg.tpForeignRegisterThreads);
        executor.setQueueCapacity(resCfg.tpForeignRegisterQueue);
        executor.setAllowCoreThreadTimeOut(true);
        executor.setThreadNamePrefix("pt-");
        executor.initialize();
        executor.setRejectedExecutionHandler((r, exec) -> {
            if (r instanceof PartnerTransportTask) {
                PartnerTransportTask t = (PartnerTransportTask)r;
                t.sendTaksRejectedEmail();
            } else {
                log.error("Task rejected from executor! Class: {}", (Object)r.getClass().getSimpleName());
            }
        });
        return executor;
    }
}

