/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import de.rtb.pcon.api.remote_data_acces.ExportedPdmDao;
import de.rtb.pcon.model.Area;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(name="Area", description="Geographical group of PDMs. Typically one town.")
class ExportedAreaDao {
    @Schema(description="Area number")
    @JacksonXmlProperty(isAttribute=true)
    private int id;
    @Schema(description="Area name")
    private String name;
    @Schema(description="Time zone", example="Europe/Berlin")
    @JacksonXmlProperty(isAttribute=true)
    private String timeZone;
    @Schema(description="PDMs belonging to the area")
    @JacksonXmlElementWrapper(localName="pdms")
    @JacksonXmlProperty(localName="pdm")
    private List<ExportedPdmDao> pdms;

    public ExportedAreaDao(Area area) {
        this.id = area.getId();
        this.name = area.getName();
        this.timeZone = area.getTimeZoneName();
        this.pdms = area.getZones().stream().flatMap(z -> z.getPdms().stream()).map(ExportedPdmDao::new).toList();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public List<ExportedPdmDao> getPdms() {
        return this.pdms;
    }
}

