/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1.dao;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitBasicDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitValidity;
import de.rtb.pcon.model.PaymentTransaction;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;

/*
 * Exception performing whole class analysis ignored.
 */
@Schema(name="PermitValidated", description="Parking permit with validation information.", subTypes={EnfPermitDao.class})
@JacksonXmlRootElement(localName="permit")
public class EnfPermitValidatedDao
extends EnfPermitBasicDao {
    private EnfPermitValidity validity;
    @Schema(description="Number of remaining minutes.")
    private Integer remains;

    public EnfPermitValidatedDao(PaymentTransaction pt, ZoneId timeZone, Duration gracePeriod) {
        super(pt, timeZone);
        Duration remainingTime = Duration.between(OffsetDateTime.now(), pt.getParkEndTime());
        this.validity = EnfPermitValidatedDao.validate((Duration)remainingTime, (Duration)gracePeriod);
        this.remains = (int)Duration.between(OffsetDateTime.now(), pt.getParkEndTime()).toMinutes();
    }

    public static EnfPermitValidity validate(Duration remainingTime, Duration gracePeriod) {
        EnfPermitValidity result = !remainingTime.isNegative() ? EnfPermitValidity.VALID : (remainingTime.plus(gracePeriod).isNegative() ? EnfPermitValidity.INVALID : EnfPermitValidity.IN_GRACE_PERIOD);
        return result;
    }

    public EnfPermitValidity getValidity() {
        return this.validity;
    }

    public Integer getRemains() {
        return this.remains;
    }
}

