/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1;

import de.rtb.pcon.api.enforcement.v1.EnforcementRepositoryV1;
import de.rtb.pcon.api.enforcement.v1.dao.EnfAreaWithZonesDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfZoneDao;
import de.rtb.pcon.api.enforcement.v1.dao.LpnAndParkTimeProjection;
import de.rtb.pcon.core.consts.AppConst;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.services.SecurityService;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class EnforcementServiceV1 {
    private EnforcementRepositoryV1 enforcementRepo;
    private SecurityService securityService;
    private static final Set<PaymentReason> ENFORCEMENT_RELEVANT_PAYMENT_REASONS = Set.of(PaymentReason.PURCHASE, PaymentReason.RTP_LOGON, PaymentReason.RTP_LOGOFF, PaymentReason.RTP);

    public EnforcementServiceV1(EnforcementRepositoryV1 enforcementRepo, SecurityService securityService) {
        this.enforcementRepo = enforcementRepo;
        this.securityService = securityService;
    }

    public List<EnfAreaWithZonesDao> zoneTree() {
        List allowedAreas = this.securityService.getCurrentAreas();
        LinkedList<EnfAreaWithZonesDao> result = new LinkedList<EnfAreaWithZonesDao>();
        for (Area area : allowedAreas) {
            boolean hasEnforcement = area.getZones().stream().anyMatch(EnfZoneDao.enforecmentEnabled);
            if (!hasEnforcement) continue;
            result.add(new EnfAreaWithZonesDao(area));
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Optional<PaymentTransaction> validateLpn(Zone zone, String lpn) {
        OffsetDateTime searchStart = OffsetDateTime.now().minus(AppConst.COMMON_SENSE_HISTORY_DEPTH);
        return this.enforcementRepo.findPermitsByLpn(zone, (Collection)ENFORCEMENT_RELEVANT_PAYMENT_REASONS, lpn, searchStart, (Pageable)PageRequest.of((int)0, (int)1)).stream().findFirst();
    }

    @Transactional(readOnly=true)
    public Optional<PaymentTransaction> validatePsn(Zone zone, int psn) {
        OffsetDateTime searchStart = OffsetDateTime.now().minus(AppConst.COMMON_SENSE_HISTORY_DEPTH);
        return this.enforcementRepo.findPermistByPsn(zone, (Collection)ENFORCEMENT_RELEVANT_PAYMENT_REASONS, Integer.valueOf(psn), searchStart, (Pageable)PageRequest.of((int)0, (int)1)).stream().findFirst();
    }

    @Transactional(readOnly=true)
    public List<LpnAndParkTimeProjection> propseLpns(Zone zone, String lpnPart, int maxProposals) {
        OffsetDateTime searchStart = OffsetDateTime.now().minus(AppConst.COMMON_SENSE_HISTORY_DEPTH);
        return this.enforcementRepo.recentLicensePlates(zone, (Collection)ENFORCEMENT_RELEVANT_PAYMENT_REASONS, "%" + lpnPart + "%", searchStart, (Pageable)PageRequest.of((int)0, (int)maxProposals));
    }

    @Transactional(readOnly=true)
    public List<PaymentTransaction> listPermitExtensions(PaymentTransaction basePayment) {
        OffsetDateTime searchStart = OffsetDateTime.now().minus(AppConst.COMMON_SENSE_HISTORY_DEPTH);
        return this.enforcementRepo.listPermitExtensions(basePayment, searchStart);
    }

    @Transactional(readOnly=true)
    public List<PaymentTransaction> listActiveParkingSessions(Zone zone, Duration historyWindow) {
        OffsetDateTime now = OffsetDateTime.now();
        return this.enforcementRepo.listActive(now, zone, now.minus(historyWindow));
    }
}

