/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.aims;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import de.rtb.pcon.api.enforcement.aims.service.EnfPermit;
import de.rtb.pcon.model.PaymentTransactionId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.stream.Collectors;

@Schema(description="Parking permit")
@JacksonXmlRootElement(localName="plate")
public class AimsPermit {
    @JsonIgnore
    private PaymentTransactionId id;
    @Schema(description="Car license plate number.", example="PBAB123")
    @JacksonXmlText
    private String licenseNumber;
    @Schema(description="Number of remaining minutes of parking time.", example="5")
    @JacksonXmlProperty(isAttribute=true)
    private Long remains;
    @Schema(description="The scope Scope where the permit was issued. In case of multiple scopes they are comma separated.", example="1,2")
    @JacksonXmlProperty(isAttribute=true)
    private String scope;
    @Schema(description="Tells if permit is valid", example="true")
    @JacksonXmlProperty(isAttribute=true)
    private Boolean valid;

    public AimsPermit() {
    }

    public AimsPermit(EnfPermit ep) {
        ZonedDateTime now = ZonedDateTime.now();
        this.id = ep.getId();
        this.licenseNumber = ep.getLicensePlate();
        this.remains = Duration.between(now, ep.getValidTo()).toMinutes();
        this.scope = ep.getValidInZones().stream().sorted(Integer::compare).map(z -> Integer.toString(z)).collect(Collectors.joining(","));
    }

    public AimsPermit(EnfPermit ep, boolean valid) {
        ZonedDateTime now = ZonedDateTime.now();
        this.id = ep.getId();
        this.licenseNumber = ep.getLicensePlate();
        this.remains = Duration.between(now, ep.getValidTo()).toMinutes();
        this.scope = ep.getValidInZones().stream().sorted(Integer::compare).map(z -> Integer.toString(z)).collect(Collectors.joining(","));
        this.valid = valid;
    }

    public PaymentTransactionId getId() {
        return this.id;
    }

    public void setId(PaymentTransactionId id) {
        this.id = id;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public Long getRemains() {
        return this.remains;
    }

    public void setRemains(Long remains) {
        this.remains = remains;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AimsPermit other = (AimsPermit)obj;
        return Objects.equals(this.id, other.id);
    }
}

